/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import javax.servlet.http.HttpServletRequest;
import nl.surfnet.coin.csa.model.LocalizedString;
import nl.surfnet.coin.shared.domain.DomainObject;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Proxy;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

@Entity
@Proxy(lazy=false)
public class MultilingualString
extends DomainObject {
    @Transient
    @JsonIgnore
    public static final Locale defaultLocale = Locale.ENGLISH;
    @Transient
    @JsonIgnore
    private static final List<String> availableLocales = Arrays.asList("nl");
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="multilingualString")
    @MapKey(name="locale")
    private Map<String, LocalizedString> localizedStrings = new HashMap<String, LocalizedString>();

    public Map<String, LocalizedString> getLocalizedStrings() {
        return this.localizedStrings;
    }

    @JsonIgnore
    public List<LocalizedString> getAllowedLocalizedStrings() {
        ArrayList<LocalizedString> result = new ArrayList<LocalizedString>();
        for (String locale : availableLocales) {
            if (this.localizedStrings.containsKey(locale)) {
                result.add(this.localizedStrings.get(locale));
                continue;
            }
            result.add(new LocalizedString(locale, "", this));
        }
        return result;
    }

    public void setLocalizedStrings(Map<String, LocalizedString> localizedStrings) {
        this.localizedStrings = localizedStrings;
    }

    public void addValue(Locale locale, String value) {
        String localeString = locale.toString();
        this.localizedStrings.put(localeString, new LocalizedString(localeString, value, this));
    }

    public void setValue(String value) {
        this.addValue(defaultLocale, value);
    }

    public String getValue() {
        String locale = this.getLocale().toString();
        return this.localeString(locale);
    }

    public String getLocaleValue(String locale) {
        return this.localeString(locale);
    }

    private String localeString(String locale) {
        LocalizedString localizedString = this.localizedStrings.get(locale);
        if (localizedString == null) {
            localizedString = this.localizedStrings.get(defaultLocale.toString());
        }
        if (localizedString == null) {
            throw new IllegalArgumentException("No LocalizedString configured for Locale " + locale.toString() + " and not for the default Locale");
        }
        return localizedString.getValue();
    }

    private Locale getLocale() {
        HttpServletRequest request;
        Locale locale = null;
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sra != null && (request = sra.getRequest()) != null) {
            locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        }
        return locale != null ? locale : defaultLocale;
    }
}

