/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa.model;

import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import nl.surfnet.coin.csa.model.FacetValue;
import nl.surfnet.coin.csa.model.MultilingualString;
import nl.surfnet.coin.shared.domain.DomainObject;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;

@Entity
@Proxy(lazy=false)
public class Facet
extends DomainObject
implements Comparable<Facet> {
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="facet")
    @Sort(type=SortType.NATURAL)
    private SortedSet<FacetValue> facetValues = new TreeSet<FacetValue>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER, mappedBy="parent")
    @Sort(type=SortType.NATURAL)
    private SortedSet<Facet> children = new TreeSet<Facet>();
    @ManyToOne
    @JoinColumn(name="facet_parent_id", nullable=true)
    private Facet parent;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="multilingual_string_id", nullable=false)
    private MultilingualString multilingualString = new MultilingualString();

    public String getName() {
        return this.multilingualString.getValue();
    }

    public String getLocaleName(String locale) {
        return this.multilingualString.getLocaleValue(locale);
    }

    public void setName(String name) {
        this.multilingualString.setValue(name);
    }

    public void addName(Locale locale, String name) {
        this.multilingualString.addValue(locale, name);
    }

    public MultilingualString getMultilingualString() {
        return this.multilingualString;
    }

    public void setMultilingualString(MultilingualString multilingualString) {
        this.multilingualString = multilingualString;
    }

    public SortedSet<FacetValue> getFacetValues() {
        return this.facetValues;
    }

    public void setFacetValues(SortedSet<FacetValue> facetValues) {
        this.facetValues = facetValues;
    }

    public void addFacetValue(FacetValue facetValue) {
        this.facetValues.add(facetValue);
        facetValue.setFacet(this);
    }

    public void removeFacetValue(FacetValue facetValue) {
        this.facetValues.remove(facetValue);
        facetValue.setFacet(null);
    }

    public SortedSet<Facet> getChildren() {
        return this.children;
    }

    public void setChildren(SortedSet<Facet> children) {
        this.children = children;
    }

    public void addChild(Facet facet) {
        this.children.add(facet);
        facet.setParent(this);
    }

    public void removeChild(Facet facet) {
        this.children.remove(facet);
        facet.setParent(null);
    }

    public Facet getParent() {
        return this.parent;
    }

    public void setParent(Facet parent) {
        this.parent = parent;
    }

    @JsonIgnore
    public boolean isUsedFacetValues() {
        for (FacetValue facetValue : this.facetValues) {
            if (facetValue.getCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Facet that) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)that.getName()).toComparison();
    }
}

