/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import nl.surfnet.coin.csa.Csa;
import nl.surfnet.coin.csa.model.Action;
import nl.surfnet.coin.csa.model.Category;
import nl.surfnet.coin.csa.model.CategoryValue;
import nl.surfnet.coin.csa.model.InstitutionIdentityProvider;
import nl.surfnet.coin.csa.model.Service;
import nl.surfnet.coin.csa.model.Statistics;
import nl.surfnet.coin.csa.model.Taxonomy;
import nl.surfnet.coin.oauth.OauthClient;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;

public class CsaClient
implements Csa {
    private static final Logger LOG = LoggerFactory.getLogger(CsaClient.class);
    private OauthClient oauthClient;
    private ObjectMapper objectMapper = new ObjectMapper().enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY}).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    private String csaBaseLocation;
    private String defaultLocale = "en";

    public CsaClient() {
    }

    public CsaClient(String csaBaseLocation) {
        this.csaBaseLocation = csaBaseLocation;
    }

    @Override
    public List<Service> getPublicServices() {
        return this.restoreCategoryReferences((List)this.oauthClient.exchange(this.csaBaseLocation + "/api/public/services.json?lang={lang}", this.getLocaleVariable(), Service[].class));
    }

    private Map getLocaleVariable() {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("lang", this.getLocale());
        return variables;
    }

    @Override
    public List<Service> getProtectedServices() {
        return this.restoreCategoryReferences((List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/services.json?lang={lang}", this.getLocaleVariable(), Service[].class));
    }

    @Override
    public List<Service> getServicesForIdp(String idpEntityId) {
        String url = this.csaBaseLocation + "/api/protected/idp/services.json?idpEntityId={idpEntityId}&lang={lang}";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        variables.put("lang", this.getLocale());
        return this.restoreCategoryReferences((List)this.oauthClient.exchange(url, variables, Service[].class));
    }

    @Override
    public Service getServiceForIdp(String idpEntityId, long serviceId) {
        String location = this.csaBaseLocation + "/api/protected/services/{serviceId}.json?idpEntityId={idpEntityId}&lang={lang}";
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("serviceId", serviceId);
        variables.put("idpEntityId", idpEntityId);
        variables.put("lang", this.getLocale());
        Service service = (Service)this.oauthClient.exchange(location, variables, Service.class);
        service.restoreCategoryReferences();
        return service;
    }

    @Override
    public Service getServiceForIdp(String idpEntityId, String spEntityId) {
        String url = this.csaBaseLocation + "/api/protected/service.json?idpEntityId={idpEntityId}&spEntityId={spEntityId}&lang={lang}";
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        variables.put("spEntityId", spEntityId);
        variables.put("lang", this.getLocale());
        Service service = (Service)this.oauthClient.exchange(url, variables, Service.class);
        service.restoreCategoryReferences();
        return service;
    }

    @Override
    public Taxonomy getTaxonomy() {
        Taxonomy taxonomy = (Taxonomy)this.oauthClient.exchange(this.csaBaseLocation + "/api/public/taxonomy.json?lang={lang}", this.getLocaleVariable(), Taxonomy.class);
        List<Category> categories = taxonomy.getCategories();
        for (Category category : categories) {
            List<CategoryValue> values = category.getValues();
            for (CategoryValue value : values) {
                value.setCategory(category);
            }
        }
        return taxonomy;
    }

    @Override
    public List<Action> getJiraActions(String idpEntityId) {
        HashMap<String, String> variables = new HashMap<String, String>();
        variables.put("idpEntityId", idpEntityId);
        return (List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/actions.json?idpEntityId={idpEntityId}", variables, Action[].class);
    }

    @Override
    public void clearProviderCache() {
        this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/cache/clear.json", String.class);
    }

    @Override
    public Action createAction(Action action) {
        return (Action)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/action.json", action, Action.class);
    }

    @Override
    public List<InstitutionIdentityProvider> getInstitutionIdentityProviders(String identityProviderId) {
        return (List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/identityproviders.json?identityProviderId={identityProviderId}", Collections.singletonMap("identityProviderId", identityProviderId), InstitutionIdentityProvider[].class);
    }

    @Override
    public List<InstitutionIdentityProvider> getAllInstitutionIdentityProviders() {
        return (List)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/all-identityproviders.json", InstitutionIdentityProvider[].class);
    }

    @Override
    public void setCsaBaseLocation(String csaBaseLocation) {
        this.csaBaseLocation = csaBaseLocation;
    }

    @Override
    public Statistics getStatistics(int month, int year) {
        if (month < 0 || month > 12 || year < 0) {
            throw new IllegalArgumentException("invalid call for statistics with month " + month + " and year " + year);
        }
        return (Statistics)this.oauthClient.exchange(this.csaBaseLocation + "/api/protected/stats.json?month=" + month + "&year=" + year, Statistics.class);
    }

    @Override
    public void setOauthClient(OauthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    private List<Service> restoreCategoryReferences(List<Service> services) {
        for (Service service : services) {
            service.restoreCategoryReferences();
        }
        return services;
    }

    private String getLocale() {
        HttpServletRequest request;
        Locale locale = null;
        ServletRequestAttributes sra = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        if (sra != null && (request = sra.getRequest()) != null) {
            locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        }
        return locale != null ? locale.getLanguage() : this.defaultLocale;
    }
}

