/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.coin.csa.model;

import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import nl.surfnet.coin.csa.model.Facet;
import nl.surfnet.coin.csa.model.MultilingualString;
import nl.surfnet.coin.shared.domain.DomainObject;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.hibernate.annotations.Proxy;

@Entity
@Proxy(lazy=false)
public class FacetValue
extends DomainObject
implements Comparable<FacetValue> {
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="facet_id", nullable=false)
    @JsonIgnore
    private Facet facet;
    @Transient
    private int count;
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="multilingual_string_id", nullable=false)
    private MultilingualString multilingualString = new MultilingualString();

    public String getValue() {
        return this.multilingualString.getValue();
    }

    public String getLocaleValue(String locale) {
        return this.multilingualString.getLocaleValue(locale);
    }

    public void setValue(String value) {
        this.multilingualString.setValue(value);
    }

    public void addValue(Locale locale, String value) {
        this.multilingualString.addValue(locale, value);
    }

    public MultilingualString getMultilingualString() {
        return this.multilingualString;
    }

    public void setMultilingualString(MultilingualString multilingualString) {
        this.multilingualString = multilingualString;
    }

    public Facet getFacet() {
        return this.facet;
    }

    public void setFacet(Facet facet) {
        this.facet = facet;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    @JsonIgnore
    public String getSearchValue() {
        String val = this.getValue();
        return val != null ? val.replaceAll(" ", "_").toLowerCase() : val;
    }

    @Override
    public int compareTo(FacetValue that) {
        return new CompareToBuilder().append((Object)this.getValue(), (Object)that.getValue()).toComparison();
    }
}

