/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.controllers;

import nl.surfnet.mujina.model.CommonConfiguration;
import nl.surfnet.mujina.model.Credential;
import nl.surfnet.mujina.model.EntityID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
public class CommonAPI {
    private static final Logger log = LoggerFactory.getLogger(CommonAPI.class);
    private CommonConfiguration configuration;

    @Autowired
    public CommonAPI(CommonConfiguration configuration) {
        this.configuration = configuration;
    }

    @RequestMapping(value={"/reset"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void reset() {
        log.debug("Resetting to default configuration");
        this.configuration.reset();
    }

    @RequestMapping(value={"/entityid"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void setEntityID(@RequestBody EntityID entityID) {
        log.debug("Request to set entityID {}", (Object)entityID.getValue());
        this.configuration.setEntityID(entityID.getValue());
    }

    @RequestMapping(value={"/signing-credential"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ResponseBody
    public void setSigningCredential(@RequestBody Credential credential) {
        log.debug("Request to set signing credential");
        this.configuration.injectCredential(credential.getCertificate(), credential.getKey());
    }
}

