/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.model;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.surfnet.mujina.model.CommonConfiguration;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConfigurationImpl
implements CommonConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonConfigurationImpl.class);
    protected KeyStore keyStore;
    protected String keystorePassword = "secret";
    protected String entityId;
    protected Map<String, String> privateKeyPasswords = new HashMap<String, String>();

    @Override
    public Map<String, String> getPrivateKeyPasswords() {
        return this.privateKeyPasswords;
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public String getEntityID() {
        return this.entityId;
    }

    @Override
    public void setEntityID(String newEntityId) {
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.keystorePassword.toCharArray());
            KeyStore.Entry keyStoreEntry = this.keyStore.getEntry(this.entityId, passwordProtection);
            this.keyStore.setEntry(newEntityId, keyStoreEntry, passwordProtection);
            this.privateKeyPasswords.put(newEntityId, this.keystorePassword);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to update signing key in key store", (Throwable)e);
        }
        this.entityId = newEntityId;
    }

    @Override
    public void injectCredential(String certificate, String key) {
        try {
            if (this.keyStore.containsAlias(this.entityId)) {
                this.keyStore.deleteEntry(this.entityId);
            }
            this.injectKeyStore(this.entityId, certificate, key);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to append signing credential");
        }
    }

    private void injectKeyStore(String alias, String pemCert, String pemKey) throws Exception {
        Certificate cert;
        String wrappedCert = "-----BEGIN CERTIFICATE-----\n" + pemCert + "\n-----END CERTIFICATE-----";
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(wrappedCert.getBytes());
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            cert = certFact.generateCertificate(certificateInputStream);
        }
        catch (CertificateException e) {
            throw new Exception("Could not instantiate cert", e);
        }
        IOUtils.closeQuietly((InputStream)certificateInputStream);
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        certs.add(cert);
        byte[] key = Base64.decodeBase64((String)pemKey);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(key);
        RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(ks);
        Certificate[] certificates = new Certificate[]{(Certificate)certs.get(0)};
        this.keyStore.setKeyEntry(alias, privKey, this.keystorePassword.toCharArray(), certificates);
    }

    protected void appendToKeyStore(KeyStore keyStore, String keyAlias, String certificateFile, String privatekeyFile, char[] password) throws Exception {
        Certificate cert;
        BufferedInputStream bis = new BufferedInputStream(this.getClass().getClassLoader().getResourceAsStream(certificateFile));
        try {
            CertificateFactory certFact = CertificateFactory.getInstance("X.509");
            cert = certFact.generateCertificate(bis);
        }
        catch (CertificateException e) {
            throw new Exception("Could not instantiate cert", e);
        }
        bis.close();
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        certs.add(cert);
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(privatekeyFile);
        byte[] privKeyBytes = IOUtils.toByteArray((InputStream)inputStream);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec ks = new PKCS8EncodedKeySpec(privKeyBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)keyFactory.generatePrivate(ks);
        Certificate[] certificates = new Certificate[]{(Certificate)certs.get(0)};
        keyStore.setKeyEntry(keyAlias, privKey, password, certificates);
    }
}

