/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import nl.surfnet.mujina.model.CommonConfiguration;
import nl.surfnet.spring.security.opensaml.util.KeyStoreUtil;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonConfigurationImpl
implements CommonConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonConfigurationImpl.class);
    protected KeyStore keyStore;
    protected String keystorePassword = "secret";
    private boolean needsSigning;
    protected String entityId;
    protected Map<String, String> privateKeyPasswords = new HashMap<String, String>();

    @Override
    public Map<String, String> getPrivateKeyPasswords() {
        return this.privateKeyPasswords;
    }

    @Override
    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public boolean needsSigning() {
        return this.needsSigning;
    }

    @Override
    public void setSigning(boolean needsSigning) {
        this.needsSigning = needsSigning;
    }

    @Override
    public String getEntityID() {
        return this.entityId;
    }

    @Override
    public void setEntityID(String newEntityId) {
        try {
            KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(this.keystorePassword.toCharArray());
            KeyStore.Entry keyStoreEntry = this.keyStore.getEntry(this.entityId, passwordProtection);
            this.keyStore.setEntry(newEntityId, keyStoreEntry, passwordProtection);
            this.privateKeyPasswords.put(newEntityId, this.keystorePassword);
        }
        catch (Exception e) {
            LOGGER.warn("Unable to update signing key in key store", (Throwable)e);
        }
        this.entityId = newEntityId;
    }

    @Override
    public void injectCredential(String certificate, String key) {
        try {
            if (this.keyStore.containsAlias(this.entityId)) {
                this.keyStore.deleteEntry(this.entityId);
            }
            this.injectKeyStore(this.entityId, certificate, key);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to append signing credential", e);
        }
    }

    private void injectKeyStore(String alias, String pemCert, String pemKey) throws Exception {
        String wrappedCert = "-----BEGIN CERTIFICATE-----\n" + pemCert + "\n-----END CERTIFICATE-----";
        ByteArrayInputStream certificateInputStream = new ByteArrayInputStream(wrappedCert.getBytes());
        byte[] key = Base64.decodeBase64((String)pemKey);
        KeyStoreUtil.appendKeyToKeyStore((KeyStore)this.keyStore, (String)alias, (InputStream)certificateInputStream, (InputStream)new ByteArrayInputStream(key), (char[])this.keystorePassword.toCharArray());
    }
}

