/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import nl.surfnet.mujina.saml.xml.IssuerGenerator;
import nl.surfnet.mujina.util.IDService;
import nl.surfnet.mujina.util.TimeService;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.springframework.util.StringUtils;

public class AuthnRequestGenerator {
    private XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private final TimeService timeService;
    private final IDService idService;
    private IssuerGenerator issuerGenerator;

    public AuthnRequestGenerator(String issuingEntityName, TimeService timeService, IDService idService) {
        this.timeService = timeService;
        this.idService = idService;
        this.issuerGenerator = new IssuerGenerator(issuingEntityName);
    }

    public AuthnRequest generateAuthnRequest(String destination, String responseLocation, String protocolBinding) {
        AuthnRequestBuilder authnRequestBuilder = (AuthnRequestBuilder)this.builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        AuthnRequest authnRequest = authnRequestBuilder.buildObject();
        if (StringUtils.hasText((String)responseLocation)) {
            authnRequest.setAssertionConsumerServiceURL(responseLocation);
        }
        authnRequest.setID(this.idService.generateID());
        authnRequest.setIssueInstant(this.timeService.getCurrentDateTime());
        authnRequest.setDestination(destination);
        if (StringUtils.hasText((String)protocolBinding)) {
            authnRequest.setProtocolBinding(protocolBinding);
        }
        authnRequest.setIssuer(this.issuerGenerator.generateIssuer());
        return authnRequest;
    }
}

