/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import org.opensaml.Configuration;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.security.SAMLSignatureProfileValidator;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.security.SecurityPolicyException;
import org.opensaml.ws.security.SecurityPolicyRule;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.impl.ExplicitKeySignatureTrustEngine;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SignatureSecurityPolicyRule
implements InitializingBean,
SecurityPolicyRule {
    private static final Logger log = LoggerFactory.getLogger(SignatureSecurityPolicyRule.class);
    private final CredentialResolver credentialResolver;
    private final SAMLSignatureProfileValidator samlSignatureProfileValidator;
    ExplicitKeySignatureTrustEngine trustEngine;

    public SignatureSecurityPolicyRule(CredentialResolver credentialResolver, SAMLSignatureProfileValidator samlSignatureProfileValidator) {
        this.credentialResolver = credentialResolver;
        this.samlSignatureProfileValidator = samlSignatureProfileValidator;
    }

    public void afterPropertiesSet() throws Exception {
        KeyInfoCredentialResolver keyInfoCredResolver = Configuration.getGlobalSecurityConfiguration().getDefaultKeyInfoCredentialResolver();
        this.trustEngine = new ExplicitKeySignatureTrustEngine(this.credentialResolver, keyInfoCredResolver);
    }

    public void evaluate(MessageContext messageContext) throws SecurityPolicyException {
        log.debug("evaluating signature of {}", (Object)messageContext);
        if (!(messageContext.getInboundMessage() instanceof SignableSAMLObject)) {
            throw new SecurityPolicyException("Inbound Message is not a SignableSAMLObject");
        }
        SignableSAMLObject samlMessage = (SignableSAMLObject)messageContext.getInboundMessage();
        this.checkSignatureProfile(samlMessage);
    }

    private void checkSignatureProfile(SignableSAMLObject samlMessage) throws SecurityPolicyException {
        try {
            Signature signature = samlMessage.getSignature();
            if (signature != null) {
                this.samlSignatureProfileValidator.validate(signature);
            }
        }
        catch (ValidationException ve) {
            throw new SecurityPolicyException("Signature did not conform to SAML Signature profile", (Exception)((Object)ve));
        }
    }
}

