/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml.xml;

import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointGenerator {
    private static final Logger logger = LoggerFactory.getLogger(EndpointGenerator.class);
    private XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();

    public Endpoint generateEndpoint(QName service, String location, String responseLocation) {
        logger.debug("end point service: {}", (Object)service);
        logger.debug("end point location: {}", (Object)location);
        logger.debug("end point responseLocation: {}", (Object)responseLocation);
        SAMLObjectBuilder endpointBuilder = (SAMLObjectBuilder)this.builderFactory.getBuilder(service);
        Endpoint samlEndpoint = (Endpoint)endpointBuilder.buildObject();
        samlEndpoint.setLocation(location);
        if (StringUtils.isNotEmpty((String)responseLocation)) {
            samlEndpoint.setResponseLocation(responseLocation);
        }
        return samlEndpoint;
    }
}

