/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.mujina.saml.SAMLRequestHandler;
import org.opensaml.saml2.core.LogoutRequest;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;

public class SAMLLogoutRequestHandler
implements SAMLRequestHandler<LogoutRequest> {
    private final String sloResponderURI;
    private final SessionRegistry sessionRegistry;

    public SAMLLogoutRequestHandler(String sloResponderURI, SessionRegistry sessionRegistry) {
        this.sloResponderURI = sloResponderURI;
        this.sessionRegistry = sessionRegistry;
    }

    @Override
    public void handleSAMLRequest(HttpServletRequest request, HttpServletResponse response, LogoutRequest logoutRequest) throws ServletException, IOException {
        List sessions = this.sessionRegistry.getAllSessions((Object)logoutRequest.getNameID().getValue(), false);
        for (SessionInformation sessionInformation : sessions) {
            sessionInformation.expireNow();
        }
        request.getRequestDispatcher(this.sloResponderURI).forward((ServletRequest)request, (ServletResponse)response);
    }

    @Override
    public String getTypeLocalName() {
        return "LogoutRequest";
    }
}

