/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import java.io.IOException;
import nl.surfnet.mujina.model.CommonConfiguration;
import nl.surfnet.mujina.model.Endpoint;
import nl.surfnet.mujina.saml.SigningService;
import nl.surfnet.mujina.saml.xml.LogoutRequestGenerator;
import nl.surfnet.mujina.util.IDService;
import nl.surfnet.mujina.util.TimeService;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.xml.security.utils.Base64;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.ws.soap.client.http.HttpClientBuilder;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Node;

public class SLORequestSender {
    private static final Logger logger = LoggerFactory.getLogger(SLORequestSender.class);
    private final CommonConfiguration configuration;
    private final TimeService timeService;
    private final IDService idService;
    private final HttpClient httpClient;
    private final SigningService signingService;

    @Autowired
    public SLORequestSender(CommonConfiguration configuration, TimeService timeService, IDService idService, SigningService signingService) {
        this.configuration = configuration;
        this.timeService = timeService;
        this.idService = idService;
        this.signingService = signingService;
        HttpClientBuilder clientBuilder = new HttpClientBuilder();
        clientBuilder.setConnectionRetryAttempts(3);
        clientBuilder.setConnectionTimeout(2000);
        clientBuilder.setMaxConnectionsPerHost(10);
        clientBuilder.setMaxTotalConnections(20);
        this.httpClient = clientBuilder.buildClient();
        HttpClientParams httpParams = this.httpClient.getParams();
        httpParams.setParameter("http.socket.timeout", (Object)5000);
    }

    public void sendSLORequest(String subject, String reason) {
        Endpoint sloEndpoint = this.configuration.getSLOEndpoint();
        if (sloEndpoint == null) {
            return;
        }
        LogoutRequestGenerator logoutRequestGenerator = new LogoutRequestGenerator(this.signingService, this.configuration.getEntityID(), this.timeService, this.idService);
        LogoutRequest logoutRequest = logoutRequestGenerator.buildLogoutRequest(subject, reason);
        this.sendSLORequestViaPOST(logoutRequest);
    }

    private void sendSLORequestViaPOST(LogoutRequest logoutRequest) {
        Endpoint sloEndpoint = this.configuration.getSLOEndpoint();
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)logoutRequest);
        String requestString = "";
        try {
            requestString = XMLHelper.prettyPrintXML((Node)marshaller.marshall((XMLObject)logoutRequest));
        }
        catch (MarshallingException e) {
            logger.error("Marshalling exception: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            PostMethod method = new PostMethod(sloEndpoint.getUrl());
            method.addParameter("SAMLRequest", Base64.encode((byte[])requestString.getBytes()));
            this.httpClient.executeMethod((HttpMethod)method);
        }
        catch (IOException e) {
            logger.error("IO exception when sending SLO Request ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

