/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.mujina.model.CommonConfiguration;
import nl.surfnet.mujina.saml.xml.EndpointGenerator;
import nl.surfnet.mujina.saml.xml.LogoutResponseGenerator;
import nl.surfnet.mujina.util.IDService;
import nl.surfnet.mujina.util.TimeService;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import org.apache.commons.lang.Validate;
import org.opensaml.common.SignableSAMLObject;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.metadata.Endpoint;
import org.opensaml.saml2.metadata.SingleSignOnService;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestHandler;

public class SSOSuccessLogoutResponder
implements HttpRequestHandler {
    private final TimeService timeService;
    private final IDService idService;
    private final SAMLMessageHandler adapter;
    private CredentialResolver credentialResolver;
    private final CommonConfiguration configuration;
    private static final Logger logger = LoggerFactory.getLogger(SSOSuccessLogoutResponder.class);

    public SSOSuccessLogoutResponder(TimeService timeService, IDService idService, SAMLMessageHandler adapter, CredentialResolver credentialResolver, CommonConfiguration configuration) {
        this.timeService = timeService;
        this.idService = idService;
        this.adapter = adapter;
        this.credentialResolver = credentialResolver;
        this.configuration = configuration;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(this.configuration.getEntityID()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        Credential signingCredential = this.getCredential(response, criteriaSet);
        if (signingCredential == null) {
            return;
        }
        LogoutResponseGenerator logoutResponseGenerator = new LogoutResponseGenerator(this.configuration.getEntityID(), this.timeService, this.idService);
        EndpointGenerator endpointGenerator = new EndpointGenerator();
        LogoutResponse logoutResponse = logoutResponseGenerator.buildLogoutResponse();
        String relayState = request.getParameter("RelayState");
        if (this.configuration.getSLOEndpoint() == null) {
            return;
        }
        String sloEndpointURL = this.configuration.getSLOEndpoint().getUrl();
        Endpoint endpoint = endpointGenerator.generateEndpoint(SingleSignOnService.DEFAULT_ELEMENT_NAME, sloEndpointURL, null);
        try {
            this.adapter.sendSAMLMessage((SignableSAMLObject)logoutResponse, endpoint, response, relayState, signingCredential);
        }
        catch (MessageEncodingException mee) {
            logger.error("Exception encoding SAML message", (Throwable)mee);
            response.sendError(503);
        }
    }

    private Credential getCredential(HttpServletResponse response, CriteriaSet criteriaSet) throws IOException {
        Credential signingCredential;
        try {
            signingCredential = (Credential)this.credentialResolver.resolveSingle((Object)criteriaSet);
        }
        catch (SecurityException e) {
            logger.warn("Unable to resolve EntityID while signing", (Throwable)e);
            response.sendError(500);
            return null;
        }
        Validate.notNull((Object)signingCredential);
        return signingCredential;
    }
}

