/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import nl.surfnet.mujina.model.CommonConfiguration;
import org.opensaml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.security.CriteriaSet;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.credential.CredentialResolver;
import org.opensaml.xml.security.credential.UsageType;
import org.opensaml.xml.security.criteria.EntityIDCriteria;
import org.opensaml.xml.security.criteria.UsageCriteria;
import org.opensaml.xml.signature.SignableXMLObject;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SigningService {
    private static final Logger logger = LoggerFactory.getLogger(SigningService.class);
    private final CommonConfiguration idpConfiguration;
    private final CredentialResolver credentialResolver;

    @Autowired
    public SigningService(CommonConfiguration configuration, CredentialResolver credentialResolver) {
        this.idpConfiguration = configuration;
        this.credentialResolver = credentialResolver;
    }

    public void signXMLObject(SignableXMLObject signableXMLObject) {
        Signature signature = (Signature)Configuration.getBuilderFactory().getBuilder(Signature.DEFAULT_ELEMENT_NAME).buildObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential(this.getCredential());
        signature.setSignatureAlgorithm(this.idpConfiguration.getSignatureAlgorithm());
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        signableXMLObject.setSignature(signature);
        try {
            Configuration.getMarshallerFactory().getMarshaller((XMLObject)signableXMLObject).marshall((XMLObject)signableXMLObject);
        }
        catch (MarshallingException e) {
            logger.error("Cannot marshal signed object: ", (Throwable)e);
            throw new RuntimeException(e);
        }
        try {
            Signer.signObject((Signature)signature);
        }
        catch (SignatureException e) {
            logger.error("SignatureException when signing object: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Credential getCredential() {
        CriteriaSet criteriaSet = new CriteriaSet();
        criteriaSet.add((Object)new EntityIDCriteria(this.idpConfiguration.getEntityID()));
        criteriaSet.add((Object)new UsageCriteria(UsageType.SIGNING));
        try {
            return (Credential)this.credentialResolver.resolveSingle((Object)criteriaSet);
        }
        catch (SecurityException e) {
            logger.error("Unable to resolve EntityID while signing", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

