/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import nl.surfnet.mujina.saml.SAMLRequestHandler;
import nl.surfnet.mujina.saml.xml.SAML2ValidatorSuite;
import nl.surfnet.spring.security.opensaml.SAMLMessageHandler;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.validation.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.HttpRequestHandler;

public class SingleSignOnService
implements HttpRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(SingleSignOnService.class);
    private final SAMLMessageHandler adapter;
    private final SAML2ValidatorSuite validatorSuite;
    private final List<SAMLRequestHandler<RequestAbstractType>> requestHandlerList;

    public SingleSignOnService(SAMLMessageHandler adapter, SAML2ValidatorSuite validatorSuite, List<SAMLRequestHandler<RequestAbstractType>> requestHandlerList) {
        this.adapter = adapter;
        this.validatorSuite = validatorSuite;
        this.requestHandlerList = requestHandlerList;
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        SAMLMessageContext messageContext = null;
        try {
            messageContext = this.adapter.extractSAMLMessageContext(request);
        }
        catch (MessageDecodingException | SecurityException mde) {
            logger.error("Exception decoding SAML message", mde);
            response.setStatus(500);
            return;
        }
        RequestAbstractType inboundSAMLMessage = (RequestAbstractType)messageContext.getInboundSAMLMessage();
        try {
            this.validatorSuite.validate((XMLObject)inboundSAMLMessage);
        }
        catch (ValidationException ve) {
            logger.warn("SAML Message failed Validation", (Throwable)ve);
            response.setStatus(500);
            return;
        }
        for (SAMLRequestHandler<RequestAbstractType> samlRequestHandler : this.requestHandlerList) {
            if (!samlRequestHandler.getTypeLocalName().equals(inboundSAMLMessage.getElementQName().getLocalPart())) continue;
            samlRequestHandler.handleSAMLRequest(request, response, inboundSAMLMessage);
        }
    }
}

