/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.mujina.saml.xml;

import nl.surfnet.mujina.saml.xml.IssuerGenerator;
import nl.surfnet.mujina.saml.xml.StatusGenerator;
import nl.surfnet.mujina.util.IDService;
import nl.surfnet.mujina.util.TimeService;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.impl.LogoutResponseBuilder;
import org.opensaml.xml.XMLObjectBuilderFactory;

public class LogoutResponseGenerator {
    private final XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
    private final IDService idService;
    private final TimeService timeService;
    private final IssuerGenerator issuerGenerator;
    private final StatusGenerator statusGenerator;

    public LogoutResponseGenerator(String issuingEntityName, TimeService timeService, IDService idService) {
        this.idService = idService;
        this.timeService = timeService;
        this.issuerGenerator = new IssuerGenerator(issuingEntityName);
        this.statusGenerator = new StatusGenerator();
    }

    public LogoutResponse buildLogoutResponse() {
        LogoutResponseBuilder logoutRequestBuilder = (LogoutResponseBuilder)this.builderFactory.getBuilder(LogoutResponse.DEFAULT_ELEMENT_NAME);
        LogoutResponse logoutResponse = logoutRequestBuilder.buildObject();
        logoutResponse.setID(this.idService.generateID());
        logoutResponse.setIssuer(this.issuerGenerator.generateIssuer());
        logoutResponse.setIssueInstant(this.timeService.getCurrentDateTime());
        logoutResponse.setStatus(this.statusGenerator.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success"));
        return logoutResponse;
    }
}

