/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.oauth.http.HttpMessage;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.opensocial.Request;
import org.opensocial.RequestException;
import org.opensocial.Response;
import org.opensocial.auth.AuthScheme;
import org.opensocial.http.HttpClient;
import org.opensocial.http.HttpClientImpl;
import org.opensocial.http.HttpResponseMessage;
import org.opensocial.providers.Provider;

public class Client {
    private Provider provider;
    private AuthScheme authScheme;
    private HttpClient httpClient;
    private static Logger logger = Logger.getLogger("org.opensocial.client");

    public Client(Provider provider, AuthScheme authScheme) {
        this(provider, authScheme, new HttpClientImpl());
    }

    public Client(Provider provider, AuthScheme authScheme, HttpClient httpClient) {
        this.provider = provider;
        this.authScheme = authScheme;
        this.httpClient = httpClient;
    }

    public Provider getProvider() {
        return this.provider;
    }

    public AuthScheme getAuthScheme() {
        return this.authScheme;
    }

    public Response send(Request request) throws RequestException, IOException {
        String KEY = "key";
        HashMap<String, Request> requests = new HashMap<String, Request>();
        requests.put("key", request);
        Map<String, Response> responses = this.send(requests);
        return responses.get("key");
    }

    public Map<String, Response> send(Map<String, Request> requests) throws RequestException, IOException {
        if (requests.size() == 0) {
            throw new RequestException("Request queue is empty");
        }
        HashMap<String, Response> responses = new HashMap();
        if (this.provider.getRpcEndpoint() != null) {
            responses = this.submitRpc(requests);
        } else if (this.provider.getRestEndpoint() != null) {
            for (Map.Entry<String, Request> entry : requests.entrySet()) {
                Request request = entry.getValue();
                this.provider.preRequest(request);
                Response response = this.submitRestRequest(request);
                responses.put(entry.getKey(), response);
                this.provider.postRequest(request, response);
            }
        } else {
            throw new RequestException("Provider has no REST or RPC endpoint set");
        }
        return responses;
    }

    private Map<String, Response> submitRpc(Map<String, Request> requests) throws RequestException, IOException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (requests.size() == 1 && requests.values().iterator().next().getContentType() != null) {
            requestHeaders.put("Content-Type", requests.values().iterator().next().getContentType());
        } else {
            requestHeaders.put("Content-Type", this.provider.getContentType());
        }
        HttpMessage message = this.authScheme.getHttpMessage(this.provider, "POST", this.buildRpcUrl(requests), requestHeaders, this.buildRpcPayload(requests));
        HttpResponseMessage responseMessage = this.httpClient.execute(message);
        logger.finest(this.buildLogRecord(requests, responseMessage));
        Map<String, Response> responses = Response.parseRpcResponse(requests, responseMessage, this.provider.getVersion());
        return responses;
    }

    private Response submitRestRequest(Request request) throws RequestException, IOException {
        HashMap<String, String> requestHeaders = new HashMap<String, String>();
        if (request.getContentType() != null) {
            requestHeaders.put("Content-Type", request.getContentType());
        } else {
            requestHeaders.put("Content-Type", this.provider.getContentType());
        }
        HttpMessage message = this.authScheme.getHttpMessage(this.provider, request.getRestMethod(), this.buildRestUrl(request), requestHeaders, this.buildRestPayload(request));
        HttpResponseMessage responseMessage = this.httpClient.execute(message);
        logger.finest(this.buildLogRecord(request, responseMessage));
        Response response = Response.parseRestResponse(request, responseMessage, this.provider.getVersion());
        return response;
    }

    String buildRpcUrl(Map<String, Request> requests) {
        StringBuilder builder = new StringBuilder(this.provider.getRpcEndpoint());
        if (builder.charAt(builder.length() - 1) == '/') {
            builder.deleteCharAt(builder.length() - 1);
        }
        if (requests.size() == 1) {
            this.appendQueryString(builder, requests.values().iterator().next().getRpcQueryStringParameters());
        }
        return builder.toString();
    }

    byte[] buildRpcPayload(Map<String, Request> requests) {
        if (requests.size() == 1 && requests.values().iterator().next().getCustomPayload() != null) {
            return requests.values().iterator().next().getCustomPayload();
        }
        JSONArray requestArray = new JSONArray();
        for (Map.Entry<String, Request> requestEntry : requests.entrySet()) {
            JSONObject request = new JSONObject();
            request.put((Object)"id", (Object)requestEntry.getKey());
            request.put((Object)"method", (Object)requestEntry.getValue().getRpcMethod());
            JSONObject requestParams = new JSONObject();
            for (Map.Entry<String, Object> parameter : requestEntry.getValue().getRpcPayloadParameters().entrySet()) {
                requestParams.put((Object)parameter.getKey(), parameter.getValue());
            }
            request.put((Object)"params", (Object)requestParams);
            requestArray.add((Object)request);
        }
        try {
            return requestArray.toJSONString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    String buildRestUrl(Request request) {
        String[] components;
        StringBuilder builder = new StringBuilder(this.provider.getRestEndpoint());
        for (String component : components = request.getRestUrlTemplate().split("/")) {
            if (component.startsWith("{") && component.endsWith("}")) {
                String tag = component.substring(1, component.length() - 1);
                if (request.getComponent(tag) == null) continue;
                builder.append(request.getComponent(tag));
                builder.append("/");
                continue;
            }
            builder.append(component);
            builder.append("/");
        }
        builder.deleteCharAt(builder.length() - 1);
        Map<String, String> parameters = request.getRestQueryStringParameters();
        this.appendQueryString(builder, parameters);
        return builder.toString();
    }

    byte[] buildRestPayload(Request request) {
        if (request.getCustomPayload() != null) {
            return request.getCustomPayload();
        }
        Map<String, Object> parameters = request.getRestPayloadParameters();
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        JSONObject payload = new JSONObject();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            payload.put((Object)parameter.getKey(), parameter.getValue());
        }
        try {
            return payload.toJSONString().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private void appendQueryString(StringBuilder builder, Map<String, String> parameters) {
        if (parameters != null && parameters.size() > 0) {
            boolean runOnce = false;
            for (Map.Entry<String, String> parameter : parameters.entrySet()) {
                if (!runOnce) {
                    builder.append("?");
                    runOnce = true;
                } else {
                    builder.append("&");
                }
                try {
                    builder.append(URLEncoder.encode(parameter.getKey(), "UTF-8"));
                    builder.append("=");
                    builder.append(URLEncoder.encode(parameter.getValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {}
            }
        }
    }

    private String buildLogRecord(Map<String, Request> requests, HttpResponseMessage message) {
        String payload = null;
        byte[] bytes = this.buildRpcPayload(requests);
        if (bytes != null) {
            try {
                payload = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.buildLogRecord(payload, message);
    }

    private String buildLogRecord(Request request, HttpResponseMessage message) {
        byte[] bytes;
        String payload = null;
        if (request.getCustomPayload() == null && (bytes = this.buildRestPayload(request)) != null) {
            try {
                payload = new String(bytes, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return this.buildLogRecord(payload, message);
    }

    private String buildLogRecord(String payload, HttpResponseMessage message) {
        StringBuilder builder = new StringBuilder("\n");
        builder.append(message.getMethod());
        builder.append("\n");
        builder.append(message.getUrl().toString());
        builder.append("\n");
        if (payload != null) {
            builder.append(payload);
            builder.append("\n");
        }
        builder.append(message.getStatusCode());
        builder.append("\n");
        builder.append(message.getResponse());
        return builder.toString();
    }
}

