/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.opensocial.models.Model;

public class Request {
    public static final String GUID = "guid";
    public static final String GROUP_ID = "groupId";
    public static final String SELECTOR = "selector";
    public static final String APP_ID = "appid";
    public static final String P_ID = "pid";
    public static final String ALBUM_ID = "albumId";
    public static final String ITEM_ID = "itemId";
    public static final String MOOD_ID = "moodId";
    public static final String FRIEND_ID = "friendId";
    public static final String HISTORY = "history";
    private String rpcMethod;
    private String restMethod;
    private String restUrlTemplate;
    private String contentType;
    private byte[] customPayload;
    private Map<String, String> components;
    private Map<String, Object> rpcPayloadParameters;
    private Map<String, Object> restPayloadParameters;
    private Map<String, String> rpcQueryStringParameters;
    private Map<String, String> restQueryStringParameters;
    private Class<? extends Model> modelClass;

    public Request(String restUrlTemplate, String rpcMethod, String restMethod) {
        this.rpcMethod = rpcMethod;
        this.restMethod = restMethod;
        this.restUrlTemplate = restUrlTemplate;
        this.components = new HashMap<String, String>();
    }

    public String getRpcMethod() {
        return this.rpcMethod;
    }

    public String getRestMethod() {
        return this.restMethod;
    }

    public String getRestUrlTemplate() {
        return this.restUrlTemplate;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getCustomPayload() {
        return this.customPayload;
    }

    public String getComponent(String name) {
        return this.components.get(name);
    }

    public Map<String, Object> getRpcPayloadParameters() {
        if (this.rpcPayloadParameters == null) {
            this.rpcPayloadParameters = new HashMap<String, Object>();
        }
        return this.rpcPayloadParameters;
    }

    public Map<String, Object> getRestPayloadParameters() {
        if (this.restPayloadParameters == null) {
            this.restPayloadParameters = new HashMap<String, Object>();
        }
        return this.restPayloadParameters;
    }

    public Map<String, String> getRpcQueryStringParameters() {
        if (this.rpcQueryStringParameters == null) {
            this.rpcQueryStringParameters = new HashMap<String, String>();
        }
        return this.rpcQueryStringParameters;
    }

    public Map<String, String> getRestQueryStringParameters() {
        if (this.restQueryStringParameters == null) {
            this.restQueryStringParameters = new HashMap<String, String>();
        }
        return this.restQueryStringParameters;
    }

    public Class<? extends Model> getModelClass() {
        if (this.modelClass == null) {
            return Model.class;
        }
        return this.modelClass;
    }

    public void setRestUrlTemplate(String template) {
        this.restUrlTemplate = template;
    }

    public void setGuid(String guid) {
        this.addComponent(GUID, guid);
        this.addRpcPayloadParameter("userId", guid);
    }

    public void setAppId(String appId) {
        this.addComponent(APP_ID, appId);
        this.addRpcPayloadParameter("appId", appId);
    }

    public void setGroupId(String groupId) {
        this.addComponent(GROUP_ID, groupId);
        this.addRpcPayloadParameter(GROUP_ID, groupId);
    }

    public void setSelector(String selector) {
        this.addComponent(SELECTOR, selector);
        this.addRpcPayloadParameter(GROUP_ID, selector);
    }

    public void setPId(String pid) {
        this.addComponent(P_ID, pid);
        this.addRpcPayloadParameter(P_ID, pid);
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setCustomPayload(byte[] payload) {
        this.customPayload = payload;
    }

    public void addComponent(String name, String value) {
        this.components.put(name, value);
    }

    public void addParameter(String name, String value) {
        this.addRpcPayloadParameter(name, value);
        this.addRestQueryStringParameter(name, value);
    }

    public void addParameters(Map<String, String> parameters) {
        for (Map.Entry<String, String> parameterEntry : parameters.entrySet()) {
            this.addParameter(parameterEntry.getKey(), parameterEntry.getValue());
        }
    }

    public void setCountParameter(int count) {
        this.addParameter("count", "" + count);
    }

    public void setStartIndexParameter(int startIndex) {
        this.addParameter("startIndex", "" + startIndex);
    }

    public void setFieldsParameter(String[] fields) {
        StringBuilder builder = new StringBuilder();
        for (String field : fields) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(field);
        }
        this.addRestQueryStringParameter("fields", builder.toString());
        this.addRpcPayloadParameter("fields", Arrays.asList(fields));
    }

    public void addRpcPayloadParameter(String name, Object value) {
        if (this.rpcPayloadParameters == null) {
            this.rpcPayloadParameters = new HashMap<String, Object>();
        }
        this.rpcPayloadParameters.put(name, value);
    }

    public void addRestPayloadParameter(String name, Object value) {
        if (this.restPayloadParameters == null) {
            this.restPayloadParameters = new HashMap<String, Object>();
        }
        this.restPayloadParameters.put(name, value);
    }

    public <T extends Model> void addRestPayloadParameters(T modelObject) {
        for (Map.Entry modelEntry : modelObject.entrySet()) {
            this.addRestPayloadParameter((String)modelEntry.getKey(), modelEntry.getValue());
        }
    }

    public void addRpcQueryStringParameter(String name, String value) {
        if (this.rpcQueryStringParameters == null) {
            this.rpcQueryStringParameters = new HashMap<String, String>();
        }
        this.rpcQueryStringParameters.put(name, value);
    }

    public void addRestQueryStringParameter(String name, String value) {
        if (this.restQueryStringParameters == null) {
            this.restQueryStringParameters = new HashMap<String, String>();
        }
        this.restQueryStringParameters.put(name, value);
    }

    public void setModelClass(Class<? extends Model> modelClass) {
        this.modelClass = modelClass;
    }
}

