/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensocial.Request;
import org.opensocial.http.HttpResponseMessage;
import org.opensocial.models.Model;
import org.opensocial.parsers.JsonParser;
import org.opensocial.parsers.Parser;

public class Response {
    private Long startIndex;
    private Long totalResults;
    private Long itemsPerPage;
    private String statusLink;
    private Boolean isFiltered;
    private List<Model> entries = new ArrayList<Model>();

    static Map<String, Response> parseRpcResponse(Map<String, Request> requests, HttpResponseMessage responseMessage, String version) {
        Parser parser = Response.getParser(responseMessage.getResponse());
        HashMap<String, Class<? extends Model>> modelClasses = new HashMap<String, Class<? extends Model>>();
        for (Map.Entry<String, Request> requestEntry : requests.entrySet()) {
            Request request = requestEntry.getValue();
            modelClasses.put(requestEntry.getKey(), request.getModelClass());
        }
        return parser.getResponseMap(responseMessage.getResponse(), modelClasses, version);
    }

    static Response parseRestResponse(Request request, HttpResponseMessage responseMessage, String version) {
        Parser parser = Response.getParser(responseMessage.getResponse());
        return parser.getResponseObject(responseMessage.getResponse(), request.getModelClass(), version);
    }

    private static Parser getParser(String responseBody) {
        if (responseBody.startsWith("{") || responseBody.startsWith("[")) {
            return new JsonParser();
        }
        return null;
    }

    public Long getStartIndex() {
        return this.startIndex;
    }

    public Long getTotalResults() {
        return this.totalResults;
    }

    public Long getItemsPerPage() {
        return this.itemsPerPage;
    }

    public String getStatusLink() {
        return this.statusLink;
    }

    public Boolean isFiltered() {
        return this.isFiltered;
    }

    public <T extends Model> List<T> getEntries() {
        return this.entries;
    }

    public <T extends Model> T getEntry() {
        if (this.entries == null || this.entries.size() == 0) {
            return null;
        }
        return (T)((Object)this.entries.get(0));
    }

    public void setStartIndex(Object startIndex) {
        this.startIndex = this.getLongValue(startIndex);
    }

    public void setTotalResults(Object totalResults) {
        this.totalResults = this.getLongValue(totalResults);
    }

    public void setItemsPerPage(Object itemsPerPage) {
        this.itemsPerPage = this.getLongValue(itemsPerPage);
    }

    public void setStatusLink(Object statusLink) {
        this.statusLink = (String)statusLink;
    }

    public void setIsFiltered(Object isFiltered) {
        this.isFiltered = this.getBooleanValue(isFiltered);
    }

    private Long getLongValue(Object field) {
        if (field.getClass().equals(String.class)) {
            return Long.parseLong((String)field);
        }
        if (field instanceof Number) {
            return (Long)field;
        }
        return null;
    }

    private Boolean getBooleanValue(Object field) {
        if (field.getClass().equals(String.class)) {
            return Boolean.parseBoolean((String)field);
        }
        if (field.getClass().equals(Boolean.class)) {
            return (Boolean)field;
        }
        return null;
    }
}

