/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.auth;

import java.io.IOException;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthMessage;
import net.oauth.http.HttpMessage;
import org.opensocial.RequestException;
import org.opensocial.auth.AuthScheme;
import org.opensocial.auth.OAuthScheme;
import org.opensocial.providers.Provider;

public class OAuth2LeggedScheme
extends OAuthScheme
implements AuthScheme {
    private String requesterId;

    public OAuth2LeggedScheme(String consumerKey, String consumerSecret) {
        this(consumerKey, consumerSecret, null);
    }

    public OAuth2LeggedScheme(String consumerKey, String consumerSecret, String requesterId) {
        super(consumerKey, consumerSecret);
        this.requesterId = requesterId;
    }

    @Override
    public HttpMessage getHttpMessage(Provider provider, String method, String url, Map<String, String> headers, byte[] body) throws RequestException, IOException {
        if (this.consumerKey == null || this.consumerSecret == null) {
            return null;
        }
        url = this.appendRequesterIdToQueryString(url);
        OAuthMessage message = new OAuthMessage(method, url, null, this.byteArrayToStream(body));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            message.getHeaders().add(header);
        }
        OAuthConsumer consumer = new OAuthConsumer(null, this.consumerKey, this.consumerSecret, null);
        consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        OAuthAccessor accessor = new OAuthAccessor(consumer);
        return this.getHttpMessage(message, accessor, body, provider.getSignBodyHash());
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    private String appendRequesterIdToQueryString(String url) {
        if (this.requesterId == null) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (url.indexOf(63) == -1) {
            builder.append("?xoauth_requestor_id=");
        } else {
            builder.append("&xoauth_requestor_id=");
        }
        builder.append(this.requesterId);
        return builder.toString();
    }
}

