/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.auth;

import java.io.IOException;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthConsumer;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.OAuthServiceProvider;
import net.oauth.client.OAuthClient;
import net.oauth.http.HttpMessage;
import org.opensocial.RequestException;
import org.opensocial.auth.AuthScheme;
import org.opensocial.auth.OAuthScheme;
import org.opensocial.http.HttpClient;
import org.opensocial.http.HttpClientImpl;
import org.opensocial.providers.Provider;

public class OAuth3LeggedScheme
extends OAuthScheme
implements AuthScheme,
Serializable {
    private Provider provider;
    private Token accessToken;
    private Token requestToken;
    private HttpClient httpClient;

    protected OAuth3LeggedScheme() {
    }

    public OAuth3LeggedScheme(Provider provider, String consumerKey, String consumerSecret) {
        this(provider, consumerKey, consumerSecret, new HttpClientImpl());
    }

    public OAuth3LeggedScheme(Provider provider, String consumerKey, String consumerSecret, HttpClient httpClient) {
        super(consumerKey, consumerSecret);
        this.provider = provider;
        this.httpClient = httpClient;
    }

    @Override
    public HttpMessage getHttpMessage(Provider provider, String method, String url, Map<String, String> headers, byte[] body) throws RequestException, IOException {
        return this.getHttpMessage(provider, method, url, headers, body, null);
    }

    public HttpMessage getHttpMessage(Provider provider, String method, String url, Map<String, String> headers, byte[] body, Collection<? extends Map.Entry> parameters) throws RequestException, IOException {
        OAuthAccessor accessor = this.getOAuthAccessor(this.accessToken.token, this.accessToken.secret);
        OAuthMessage message = new OAuthMessage(method, url, parameters, this.byteArrayToStream(body));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            message.getHeaders().add(header);
        }
        return this.getHttpMessage(message, accessor, body, provider.getSignBodyHash());
    }

    public String getAuthorizationUrl(String callbackUrl) throws OAuthException, URISyntaxException, IOException {
        this.requestToken = this.requestRequestToken(callbackUrl);
        if (this.requestToken.token == null) {
            return this.provider.getAuthorizeUrl() + "?oauth_callback=" + callbackUrl;
        }
        return this.provider.getAuthorizeUrl() + "?oauth_token=" + this.requestToken.token + "&oauth_callback=" + callbackUrl;
    }

    public void requestAccessToken(String oAuthToken) throws OAuthException, URISyntaxException, IOException {
        this.requestAccessToken(oAuthToken, null);
    }

    public void requestAccessToken(String oAuthToken, String oAuthVerifier) throws OAuthException, URISyntaxException, IOException {
        Set parameters = null;
        if (oAuthVerifier != null) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            parameterMap.put("oauth_verifier", oAuthVerifier);
            parameters = parameterMap.entrySet();
        }
        OAuthAccessor accessor = this.getOAuthAccessor(oAuthToken, this.requestToken.secret);
        OAuthMessage message = this.getOAuthClient().invoke(accessor, "GET", this.provider.getAccessTokenUrl(), parameters);
        this.accessToken = new Token(message.getToken(), message.getParameter("oauth_token_secret"));
    }

    public Provider getProvider() {
        return this.provider;
    }

    public Token getRequestToken() {
        return this.requestToken;
    }

    public Token getAccessToken() {
        return this.accessToken;
    }

    public void setRequestToken(Token token) {
        this.requestToken = token;
    }

    public void setAccessToken(Token token) {
        this.accessToken = token;
    }

    private Token requestRequestToken(String callbackUrl) throws OAuthException, URISyntaxException, IOException {
        if (this.provider.getRequestTokenUrl() == null) {
            return new Token();
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("oauth_callback", callbackUrl);
        HashSet extraParams = new HashSet();
        extraParams.addAll(params.entrySet());
        if (this.provider.getRequestTokenParameters() != null) {
            extraParams.addAll(this.provider.getRequestTokenParameters().entrySet());
        }
        OAuthAccessor accessor = this.getOAuthAccessor();
        this.getOAuthClient().getRequestToken(accessor, "GET", extraParams);
        return new Token(accessor.requestToken, accessor.tokenSecret);
    }

    private OAuthAccessor getOAuthAccessor() {
        OAuthServiceProvider serviceProvider = new OAuthServiceProvider(this.provider.getRequestTokenUrl(), this.provider.getAuthorizeUrl(), this.provider.getAccessTokenUrl());
        OAuthConsumer consumer = new OAuthConsumer(null, this.consumerKey, this.consumerSecret, serviceProvider);
        consumer.setProperty("oauth_signature_method", (Object)"HMAC-SHA1");
        return new OAuthAccessor(consumer);
    }

    private OAuthAccessor getOAuthAccessor(String token, String secret) {
        OAuthAccessor accessor = this.getOAuthAccessor();
        accessor.accessToken = token;
        accessor.tokenSecret = secret;
        return accessor;
    }

    private OAuthClient getOAuthClient() {
        if (this.httpClient == null) {
            this.httpClient = new HttpClientImpl();
        }
        return new OAuthClient((net.oauth.http.HttpClient)this.httpClient);
    }

    public static class Token
    implements Serializable {
        public String token;
        public String secret;

        public Token() {
        }

        public Token(String token, String secret) {
            this.token = token;
            this.secret = secret;
        }
    }
}

