/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.auth;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthException;
import net.oauth.OAuthMessage;
import net.oauth.ParameterStyle;
import net.oauth.http.HttpMessage;
import org.apache.commons.codec.binary.Base64;
import org.opensocial.RequestException;

abstract class OAuthScheme
implements Serializable {
    protected String consumerKey;
    protected String consumerSecret;

    protected OAuthScheme() {
    }

    public OAuthScheme(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    protected InputStream byteArrayToStream(byte[] bytes) {
        ByteArrayInputStream stream = null;
        if (bytes != null) {
            stream = new ByteArrayInputStream(bytes);
        }
        return stream;
    }

    protected HttpMessage getHttpMessage(OAuthMessage message, OAuthAccessor accessor, byte[] body, boolean signBodyHash) throws IOException, RequestException {
        if (body != null) {
            if (signBodyHash) {
                try {
                    MessageDigest md = MessageDigest.getInstance("SHA-1");
                    byte[] hash = md.digest(body);
                    byte[] encodedHash = new Base64().encode(hash);
                    message.addParameter("oauth_body_hash", new String(encodedHash, "UTF-8"));
                }
                catch (NoSuchAlgorithmException e) {
                }
                catch (UnsupportedEncodingException e) {}
            } else if (message.getHeader("Content-Type").equals("application/x-www-form-urlencoded")) {
                message.addParameter(this.byteArrayToString(body), "");
            }
        }
        try {
            message.addRequiredParameters(accessor);
        }
        catch (OAuthException e) {
            throw new RequestException("OAuth error thrown while signing request " + e.getMessage());
        }
        catch (URISyntaxException e) {
            throw new RequestException("Malformed request URL " + message.URL + " could not be signed");
        }
        return HttpMessage.newRequest((OAuthMessage)message, (ParameterStyle)ParameterStyle.QUERY_STRING);
    }

    private String byteArrayToString(byte[] bytes) {
        try {
            return new String(bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }
}

