/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.auth;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.oauth.http.HttpMessage;
import org.opensocial.RequestException;
import org.opensocial.auth.AuthScheme;
import org.opensocial.providers.Provider;

public class SecurityTokenScheme
implements AuthScheme {
    private String tokenName;
    private String token;

    public SecurityTokenScheme(String token) {
        this("st", token);
    }

    public SecurityTokenScheme(String tokenName, String token) {
        this.tokenName = tokenName;
        this.token = token;
    }

    @Override
    public HttpMessage getHttpMessage(Provider provider, String method, String url, Map<String, String> headers, byte[] body) throws RequestException, IOException {
        url = this.appendTokenToQueryString(url);
        HttpMessage message = new HttpMessage(method, new URL(url), this.byteArrayToStream(body));
        for (Map.Entry<String, String> header : headers.entrySet()) {
            message.headers.add(header);
        }
        return message;
    }

    private String appendTokenToQueryString(String url) {
        if (this.token == null) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        if (url.indexOf(63) == -1) {
            builder.append("?");
        } else {
            builder.append("&");
        }
        builder.append(this.tokenName);
        builder.append("=");
        builder.append(this.token);
        return builder.toString();
    }

    protected InputStream byteArrayToStream(byte[] bytes) {
        ByteArrayInputStream stream = null;
        if (bytes != null) {
            stream = new ByteArrayInputStream(bytes);
        }
        return stream;
    }
}

