/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.http;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.util.Map;
import net.oauth.http.HttpMessage;
import org.opensocial.http.HttpClient;
import org.opensocial.http.HttpResponseMessage;

public class HttpClientImpl
implements HttpClient,
Serializable {
    @Override
    public HttpResponseMessage execute(HttpMessage message) throws IOException {
        return this.execute(message, (Map)null);
    }

    public HttpResponseMessage execute(HttpMessage message, Map<String, Object> parameters) throws IOException {
        HttpURLConnection connection = null;
        try {
            connection = this.getConnection(message);
            if (message.getBody() != null) {
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.write(this.streamToByteArray(message.getBody()));
                out.flush();
                out.close();
            }
            return new HttpResponseMessage(message.method, message.url, connection.getResponseCode(), connection.getInputStream());
        }
        catch (IOException e) {
            if (connection != null) {
                return new HttpResponseMessage(message.method, message.url, connection.getResponseCode());
            }
            throw e;
        }
    }

    private HttpURLConnection getConnection(HttpMessage message) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)message.url.openConnection();
        for (Map.Entry header : message.headers) {
            connection.setRequestProperty((String)header.getKey(), (String)header.getValue());
        }
        connection.setRequestMethod(message.method);
        connection.setDoOutput(true);
        connection.connect();
        return connection;
    }

    private byte[] streamToByteArray(InputStream stream) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = stream.read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        return out.toByteArray();
    }
}

