/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;

public class HttpResponseMessage
extends net.oauth.http.HttpResponseMessage {
    private int statusCode;
    private String response;

    public HttpResponseMessage(String method, URL url, int statusCode) throws IOException {
        this(method, url, statusCode, null);
    }

    public HttpResponseMessage(String method, URL url, int statusCode, InputStream responseStream) throws IOException {
        super(method, url);
        this.statusCode = statusCode;
        this.setResponse(responseStream);
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getResponse() {
        return this.response;
    }

    public String getMethod() {
        return this.method;
    }

    public URL getUrl() {
        return this.url;
    }

    protected InputStream openBody() {
        if (this.response != null) {
            try {
                return new ByteArrayInputStream(this.response.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return null;
    }

    private void setResponse(InputStream in) {
        if (in != null) {
            try {
                String line = null;
                StringBuilder builder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                this.response = builder.toString();
                in.close();
            }
            catch (IOException e) {
                this.response = null;
            }
        }
    }
}

