/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContainerFactory;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.opensocial.Response;
import org.opensocial.models.Model;
import org.opensocial.parsers.Parser;

public class JsonParser
implements Parser {
    @Override
    public Response getResponseObject(String json, Class<? extends Model> modelClass, String version) {
        if (version.equals("0.8")) {
            return this.getResponseObject0p8(json, modelClass);
        }
        if (version.equals("0.9")) {
            return this.getResponseObject0p9(json, modelClass);
        }
        return null;
    }

    @Override
    public Map<String, Response> getResponseMap(String json, Map<String, Class<? extends Model>> modelClasses, String version) {
        if (version.equals("0.8")) {
            return this.getResponseMap0p8(json, modelClasses);
        }
        if (version.equals("0.9")) {
            return this.getResponseMap0p9(json, modelClasses);
        }
        return null;
    }

    private Response getResponseObject0p8(String json, Class<? extends Model> modelClass) {
        Response response = new Response();
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = JsonParser.getContainerFactory(modelClass);
        try {
            Map rootObject = (Map)parser.parse(json, containerFactory);
            if (rootObject.containsKey("startIndex")) {
                response.setStartIndex(rootObject.get("startIndex"));
            }
            if (rootObject.containsKey("totalResults")) {
                response.setTotalResults(rootObject.get("totalResults"));
            }
            if (rootObject.containsKey("entry")) {
                Object entry = rootObject.get("entry");
                if (entry.getClass().equals(JSONArray.class)) {
                    for (int i = 0; i < ((List)entry).size(); ++i) {
                        response.getEntries().add((Model)((Object)((List)entry).get(i)));
                    }
                } else if (entry.getClass().equals(modelClass)) {
                    response.getEntries().add((Model)((Object)entry));
                }
            }
        }
        catch (ParseException e) {
            return null;
        }
        return response;
    }

    private Map<String, Response> getResponseMap0p8(String json, Map<String, Class<? extends Model>> modelClasses) {
        HashMap<String, Response> responses = new HashMap<String, Response>();
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = JsonParser.getContainerFactory(Model.class);
        try {
            List rootArray = (List)parser.parse(json, containerFactory);
            for (Map responseObject : rootArray) {
                String id = null;
                Class<? extends Model> modelClass = null;
                Response response = new Response();
                if (responseObject.containsKey("id")) {
                    id = (String)responseObject.get("id");
                    modelClass = modelClasses.get(id);
                }
                if (responseObject.containsKey("data")) {
                    Map dataObject = (Map)responseObject.get("data");
                    if (dataObject.containsKey("startIndex")) {
                        response.setStartIndex(dataObject.get("startIndex"));
                    }
                    if (dataObject.containsKey("totalResults")) {
                        response.setTotalResults(dataObject.get("totalResults"));
                    }
                    if (dataObject.containsKey("list")) {
                        Object list = dataObject.get("list");
                        if (list.getClass().equals(JSONArray.class)) {
                            for (int i = 0; i < ((List)list).size(); ++i) {
                                Model object = (Model)((Object)((List)list).get(i));
                                response.getEntries().add(JsonParser.cloneModelObject(object, modelClass));
                            }
                        } else if (list.getClass().equals(JSONObject.class)) {
                            response.getEntries().add(JsonParser.cloneModelObject((Model)((Object)list), modelClass));
                        }
                    } else {
                        response.getEntries().add(JsonParser.cloneModelObject((Model)((Object)dataObject), modelClass));
                    }
                }
                responses.put(id, response);
            }
        }
        catch (ParseException e) {
            return null;
        }
        return responses;
    }

    private Response getResponseObject0p9(String json, Class<? extends Model> modelClass) {
        Response response = new Response();
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = JsonParser.getContainerFactory(modelClass);
        if (json.startsWith("{")) {
            try {
                Map rootObject = (Map)parser.parse(json, containerFactory);
                if (rootObject.containsKey("startIndex")) {
                    response.setStartIndex(rootObject.get("startIndex"));
                }
                if (rootObject.containsKey("totalResults")) {
                    response.setTotalResults(rootObject.get("totalResults"));
                }
                if (rootObject.containsKey("itemsPerPage")) {
                    response.setItemsPerPage(rootObject.get("itemsPerPage"));
                }
                if (rootObject.containsKey("statusLink")) {
                    response.setStatusLink(rootObject.get("statusLink"));
                }
                if (rootObject.containsKey("isFiltered")) {
                    response.setIsFiltered(rootObject.get("isFiltered"));
                }
                if (rootObject.containsKey("person")) {
                    response.getEntries().add((Model)((Object)rootObject.get("person")));
                }
                if (rootObject.containsKey("entry")) {
                    Object entry = rootObject.get("entry");
                    Class<?> clazz = entry.getClass();
                    if (clazz.equals(JSONArray.class)) {
                        for (int i = 0; i < ((List)entry).size(); ++i) {
                            Map currentEntry = (Map)((List)entry).get(i);
                            if (currentEntry.containsKey("person")) {
                                response.getEntries().add((Model)((Object)currentEntry.get("person")));
                                continue;
                            }
                            if (currentEntry.containsKey("activity")) {
                                response.getEntries().add((Model)((Object)currentEntry.get("activity")));
                                continue;
                            }
                            if (currentEntry.containsKey("album")) {
                                response.getEntries().add((Model)((Object)currentEntry.get("album")));
                                continue;
                            }
                            if (currentEntry.containsKey("mediaItem")) {
                                response.getEntries().add((Model)((Object)currentEntry.get("mediaItem")));
                                continue;
                            }
                            response.getEntries().add((Model)((Object)currentEntry));
                        }
                    }
                    Map currentEntry = (Map)entry;
                    response.getEntries().add((Model)((Object)currentEntry));
                }
                if (rootObject.containsKey("album")) {
                    response.getEntries().add((Model)((Object)rootObject.get("album")));
                }
                if (rootObject.containsKey("mediaItem")) {
                    response.getEntries().add((Model)((Object)rootObject.get("mediaItem")));
                }
                response.getEntries().add((Model)((Object)rootObject));
            }
            catch (ParseException e) {
                return null;
            }
        } else if (json.startsWith("[")) {
            try {
                List rootArray = (List)parser.parse(json, containerFactory);
                for (Map responseObject : rootArray) {
                    response.getEntries().add((Model)((Object)responseObject));
                }
            }
            catch (ParseException e) {
                return null;
            }
        }
        return response;
    }

    private Map<String, Response> getResponseMap0p9(String json, Map<String, Class<? extends Model>> modelClasses) {
        HashMap<String, Response> responses = new HashMap<String, Response>();
        JSONParser parser = new JSONParser();
        ContainerFactory containerFactory = JsonParser.getContainerFactory(Model.class);
        try {
            List rootArray = (List)parser.parse(json, containerFactory);
            for (Map responseObject : rootArray) {
                String id = null;
                Class<? extends Model> modelClass = null;
                Response response = new Response();
                if (responseObject.containsKey("id")) {
                    id = (String)responseObject.get("id");
                    modelClass = modelClasses.get(id);
                }
                if (responseObject.containsKey("result")) {
                    Map dataObject = (Map)responseObject.get("result");
                    if (dataObject.containsKey("startIndex")) {
                        response.setStartIndex(dataObject.get("startIndex"));
                    }
                    if (dataObject.containsKey("totalResults")) {
                        response.setTotalResults(dataObject.get("totalResults"));
                    }
                    if (dataObject.containsKey("list")) {
                        Object list = dataObject.get("list");
                        if (list.getClass().equals(JSONArray.class)) {
                            for (int i = 0; i < ((List)list).size(); ++i) {
                                Model object = (Model)((Object)((List)list).get(i));
                                response.getEntries().add(JsonParser.cloneModelObject(object, modelClass));
                            }
                        } else if (list.getClass().equals(JSONObject.class)) {
                            response.getEntries().add(JsonParser.cloneModelObject((Model)((Object)list), modelClass));
                        }
                    } else {
                        response.getEntries().add(JsonParser.cloneModelObject((Model)((Object)dataObject), modelClass));
                    }
                }
                responses.put(id, response);
            }
        }
        catch (ParseException e) {
            return null;
        }
        return responses;
    }

    private static ContainerFactory getContainerFactory(final Class<? extends Model> modelClass) {
        ContainerFactory containerFactory = new ContainerFactory(){

            public List creatArrayContainer() {
                return new JSONArray();
            }

            public Map createObjectContainer() {
                try {
                    return (Map)modelClass.newInstance();
                }
                catch (InstantiationException e) {
                    return new Model();
                }
                catch (IllegalAccessException e) {
                    return new Model();
                }
            }
        };
        return containerFactory;
    }

    private static Model cloneModelObject(Model model, Class<? extends Model> modelClass) {
        Model clone = null;
        try {
            clone = modelClass.newInstance();
        }
        catch (InstantiationException e) {
            return model;
        }
        catch (IllegalAccessException e) {
            return model;
        }
        for (Map.Entry entry : model.entrySet()) {
            clone.put(entry.getKey(), entry.getValue());
        }
        return clone;
    }
}

