/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.providers;

import org.opensocial.Request;
import org.opensocial.providers.Provider;

public class PlaxoProvider
extends Provider {
    private static final String REST_URL_TEMPLATE = "{guid}/{selector}/{pid}";

    public PlaxoProvider() {
        this.setName("Plaxo");
        this.setVersion("0.8");
        this.setRestEndpoint("http://www.plaxo.com/pdata/contacts/");
        this.setAuthorizeUrl("http://www.plaxo.com/oauth/authorize");
        this.setAccessTokenUrl("http://www.plaxo.com/oauth/activate");
        this.setRequestTokenUrl("http://www.plaxo.com/oauth/request");
    }

    @Override
    public void preRequest(Request request) {
        String selector;
        request.setRestUrlTemplate(REST_URL_TEMPLATE);
        String guid = request.getComponent("guid");
        if (!guid.equals("@me")) {
            request.setPId(guid);
            request.setGuid("@me");
            request.setSelector("@all");
        }
        if ((selector = request.getComponent("selector")).equals("@friends")) {
            request.setSelector("@all");
        }
    }
}

