/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.services;

import java.util.HashMap;
import org.opensocial.Request;
import org.opensocial.models.Activity;
import org.opensocial.services.Service;

public class ActivitiesService
extends Service {
    private static final String restTemplate = "activities/{guid}/{selector}/{appid}/{activityid}";

    public static Request getActivities() {
        return ActivitiesService.getActivities("@me");
    }

    public static Request getActivities(String guid) {
        Request request = new Request(restTemplate, "activities.get", "GET");
        request.setModelClass(Activity.class);
        request.setSelector("@self");
        request.setAppId("@app");
        request.setGuid(guid);
        return request;
    }

    public static Request getFriendActivities(String guid) {
        Request request = new Request(restTemplate, "activities.get", "GET");
        request.setModelClass(Activity.class);
        request.setSelector("@friends");
        request.setAppId("@app");
        request.setGuid(guid);
        return request;
    }

    public static Request createActivity(Activity activity) {
        String[] fieldNames;
        Request request = new Request(restTemplate, "activities.create", "POST");
        request.setSelector("@self");
        request.setAppId("@app");
        request.setGuid("@me");
        HashMap<String, Object> activityParameter = new HashMap<String, Object>();
        for (String fieldName : fieldNames = activity.getFieldNames()) {
            activityParameter.put(fieldName, activity.getField(fieldName));
        }
        request.addRpcPayloadParameter("activity", activityParameter);
        request.addRestPayloadParameters(activity);
        return request;
    }
}

