/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.services;

import org.opensocial.Request;
import org.opensocial.RequestException;
import org.opensocial.models.Album;
import org.opensocial.services.Service;

public class AlbumsService
extends Service {
    private static final String restTemplate = "albums/{guid}/{groupId}/{albumId}";

    public static Request getAlbums() {
        Request request = new Request(restTemplate, "albums.get", "GET");
        request.setModelClass(Album.class);
        request.setGroupId("@self");
        request.setGuid("@me");
        return request;
    }

    public static Request getAlbum(String albumId) {
        Request request = AlbumsService.getAlbums();
        request.addComponent("albumId", albumId);
        return request;
    }

    public static Request createAlbum(Album album) {
        Request request = new Request(restTemplate, "albums.create", "POST");
        request.setGroupId("@self");
        request.setGuid("@me");
        request.addRestPayloadParameters(album);
        return request;
    }

    public static Request updateAlbum(Album album) throws RequestException {
        if (album.getId() == null || album.getId().equals("")) {
            throw new RequestException("Passed Album object does not have ID property set");
        }
        Request request = new Request(restTemplate, "albums.update", "PUT");
        request.addComponent("albumId", album.getId());
        request.setGroupId("@self");
        request.setGuid("@me");
        request.addRestPayloadParameters(album);
        return request;
    }

    public static Request deleteAlbum(String albumId) {
        Request request = new Request(restTemplate, "albums.delete", "DELETE");
        request.addComponent("albumId", albumId);
        request.setGroupId("@self");
        request.setGuid("@me");
        return request;
    }
}

