/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opensocial.Request;
import org.opensocial.models.AppData;
import org.opensocial.services.Service;

public class AppDataService
extends Service {
    private static final String restTemplate = "appdata/{guid}/{selector}/{appid}";

    public static Request getAppData() {
        return AppDataService.getAppData("@me");
    }

    public static Request getAppData(String guid) {
        Request request = new Request(restTemplate, "appdata.get", "GET");
        request.setModelClass(AppData.class);
        request.setSelector("@self");
        request.setAppId("@app");
        request.setGuid(guid);
        return request;
    }

    public static Request getFriendAppData(String guid) {
        Request request = new Request(restTemplate, "appdata.get", "GET");
        request.setModelClass(AppData.class);
        request.setSelector("@friends");
        request.setAppId("@app");
        request.setGuid(guid);
        return request;
    }

    public static Request updateAppData(String key, String value) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put(key, value);
        return AppDataService.updateAppData(data);
    }

    public static Request updateAppData(Map<String, String> data) {
        Request request = new Request(restTemplate, "appdata.update", "PUT");
        request.setSelector("@self");
        request.setAppId("@app");
        request.setGuid("@viewer");
        ArrayList<String> fields = new ArrayList<String>(data.size());
        for (Map.Entry<String, String> field : data.entrySet()) {
            fields.add(field.getKey());
        }
        request.addRpcPayloadParameter("data", data);
        request.addRpcPayloadParameter("fields", fields);
        StringBuilder fieldsBuilder = new StringBuilder();
        for (Map.Entry<String, String> datum : data.entrySet()) {
            if (fieldsBuilder.length() != 0) {
                fieldsBuilder.append(",");
            }
            fieldsBuilder.append(datum.getKey());
        }
        request.addRestQueryStringParameter("fields", fieldsBuilder.toString());
        for (Map.Entry<String, String> datum : data.entrySet()) {
            request.addRestPayloadParameter(datum.getKey(), datum.getValue());
        }
        return request;
    }

    public static Request deleteAppData(String key) {
        return AppDataService.deleteAppData(new String[]{key});
    }

    public static Request deleteAppData(String[] keys) {
        ArrayList<String> keyList = new ArrayList<String>(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            keyList.add(keys[i]);
        }
        return AppDataService.deleteAppData(keyList);
    }

    public static Request deleteAppData(List<String> keys) {
        Request request = new Request(restTemplate, "appdata.delete", "DELETE");
        request.setSelector("@self");
        request.setAppId("@app");
        request.setGuid("@me");
        request.addRpcPayloadParameter("fields", keys);
        StringBuilder fieldsBuilder = new StringBuilder();
        for (String key : keys) {
            if (fieldsBuilder.length() != 0) {
                fieldsBuilder.append(",");
            }
            fieldsBuilder.append(key);
        }
        request.addRestQueryStringParameter("fields", fieldsBuilder.toString());
        return request;
    }
}

