/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.services;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.opensocial.Request;
import org.opensocial.RequestException;
import org.opensocial.models.MediaItem;
import org.opensocial.services.Service;

public class MediaItemsService
extends Service {
    private static final String restTemplate = "mediaitems/{guid}/{groupId}/{albumId}/{itemId}";

    public static Request getMediaItems(String albumId) {
        Request request = new Request(restTemplate, "mediaItems.get", "GET");
        request.setModelClass(MediaItem.class);
        request.addComponent("albumId", albumId);
        request.setGroupId("@self");
        request.setGuid("@me");
        return request;
    }

    public static Request getMediaItem(String itemId, String albumId) {
        Request request = MediaItemsService.getMediaItems(albumId);
        request.addComponent("itemId", itemId);
        return request;
    }

    public static Request getSupportedVideoCategories() {
        Request request = new Request(restTemplate, null, "GET");
        request.addComponent("albumId", "@videos");
        request.addComponent("itemId", "@supportedcategories");
        request.setGuid("@me");
        return request;
    }

    public static Request createMediaItem(MediaItem item) throws RequestException {
        if (item.getAlbumId() == null || item.getAlbumId().equals("")) {
            throw new RequestException("Passed MediaItem object does not have album_id property set");
        }
        Request request = new Request(restTemplate, "mediaItems.create", "POST");
        request.addComponent("albumId", item.getAlbumId());
        request.setGroupId("@self");
        request.setGuid("@me");
        request.addRestPayloadParameters(item);
        return request;
    }

    public static Request uploadImage(MediaItem item, File content) throws RequestException, IOException {
        Request request = MediaItemsService.uploadMediaItem(item, content);
        request.addRestQueryStringParameter("type", "image");
        return request;
    }

    public static Request uploadVideo(MediaItem item, File content) throws RequestException, IOException {
        Request request = MediaItemsService.uploadMediaItem(item, content);
        request.addRestQueryStringParameter("type", "video");
        if (item.getCaption() != null) {
            request.addRestQueryStringParameter("caption", item.getCaption());
        }
        if (item.getDescription() != null) {
            request.addRestQueryStringParameter("description", item.getDescription());
        }
        if (item.hasField("msCategories")) {
            request.addRestQueryStringParameter("msCategories", item.getFieldAsString("msCategories"));
        }
        if (item.hasField("language")) {
            request.addRestQueryStringParameter("language", item.getFieldAsString("language"));
        }
        if (item.hasField("tags")) {
            request.addRestQueryStringParameter("tags", item.getFieldAsString("tags"));
        }
        return request;
    }

    private static Request uploadMediaItem(MediaItem item, File content) throws RequestException, IOException {
        if (item.getAlbumId() == null || item.getAlbumId().equals("")) {
            throw new RequestException("Passed MediaItem object does not have album_id property set");
        }
        if (item.getMimeType() == null || item.getMimeType().equals("")) {
            throw new RequestException("Passed MediaItem object does not have mime_type property set");
        }
        Request request = new Request(restTemplate, "mediaItems.create", "POST");
        request.addComponent("albumId", item.getAlbumId());
        request.setGroupId("@self");
        request.setGuid("@me");
        byte[] bytes = MediaItemsService.getBytes(content);
        if (bytes != null) {
            request.setCustomPayload(bytes);
            request.setContentType(item.getMimeType());
        }
        return request;
    }

    private static byte[] getBytes(File file) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        FileInputStream in = new FileInputStream(file);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((read = ((InputStream)in).read(buffer)) > 0) {
            out.write(buffer, 0, read);
        }
        byte[] bytes = out.toByteArray();
        out.close();
        ((InputStream)in).close();
        return bytes;
    }

    public static Request updateMediaItem(MediaItem item) throws RequestException {
        if (item.getId() == null || item.getId().equals("")) {
            throw new RequestException("Passed MediaItem object does not have id property set");
        }
        if (item.getAlbumId() == null || item.getAlbumId().equals("")) {
            throw new RequestException("Passed MediaItem object does not have album_id property set");
        }
        Request request = new Request(restTemplate, "mediaItems.update", "PUT");
        request.addComponent("albumId", item.getAlbumId());
        request.addComponent("itemId", item.getId());
        request.setGroupId("@self");
        request.setGuid("@me");
        request.addRestPayloadParameters(item);
        return request;
    }

    public static Request deleteMediaItem(String itemId, String albumId) {
        Request request = new Request(restTemplate, "mediaItems.delete", "DELETE");
        request.addComponent("albumId", albumId);
        request.addComponent("itemId", itemId);
        request.setGroupId("@self");
        request.setGuid("@me");
        return request;
    }
}

