/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.services;

import java.util.HashMap;
import java.util.List;
import org.opensocial.Request;
import org.opensocial.models.Message;
import org.opensocial.models.MessageCollection;
import org.opensocial.services.Service;

public class MessagesService
extends Service {
    private static final String restTemplate = "messages/{guid}/{selector}";

    public static Request getMessages() {
        return MessagesService.getMessages("@me");
    }

    public static Request getMessages(String guid) {
        Request request = new Request(restTemplate, "messages.get", "GET");
        request.setModelClass(Message.class);
        request.setSelector("@self");
        request.setAppId("@app");
        request.setGuid(guid);
        return request;
    }

    public static Request createMessage(Message message) {
        String[] fieldNames;
        Request request = new Request(restTemplate, "messages.create", "POST");
        List collectionIds = message.getFieldAsList("collectionIds");
        if (collectionIds == null || collectionIds.isEmpty()) {
            throw new IllegalArgumentException("A messageCollectionId must be provided when posting a message");
        }
        request.setSelector((String)collectionIds.get(0));
        request.setAppId("@app");
        request.setGuid("@me");
        request.setModelClass(Message.class);
        HashMap<String, Object> messageParameter = new HashMap<String, Object>();
        for (String fieldName : fieldNames = message.getFieldNames()) {
            messageParameter.put(fieldName, message.getField(fieldName));
        }
        request.addRpcPayloadParameter("message", messageParameter);
        request.addRestPayloadParameters(message);
        return request;
    }

    public static Request createMessageCollection(MessageCollection messageCollection) {
        String[] fieldNames;
        Request request = new Request(restTemplate, "messages.create", "POST");
        request.setSelector(null);
        request.setAppId("@app");
        request.setGuid("@me");
        request.setModelClass(MessageCollection.class);
        HashMap<String, Object> messageParameter = new HashMap<String, Object>();
        for (String fieldName : fieldNames = messageCollection.getFieldNames()) {
            messageParameter.put(fieldName, messageCollection.getField(fieldName));
        }
        request.addRpcPayloadParameter("messageCollection", messageParameter);
        request.addRestPayloadParameters(messageCollection);
        return request;
    }
}

