/*
 * Decompiled with CFR 0.152.
 */
package org.opensocial.services.myspace;

import org.opensocial.Request;
import org.opensocial.models.myspace.StatusMood;
import org.opensocial.services.Service;

public class StatusMoodsService
extends Service {
    private static final String restTemplate = "statusmood/{guid}/{groupId}/{friendId}/{moodId}/{history}";

    public static Request getStatus() {
        return StatusMoodsService.getStatus("@me");
    }

    public static Request getStatus(String guid) {
        return StatusMoodsService.getStatus(guid, "@self");
    }

    public static Request getFriendStatuses(String guid) {
        return StatusMoodsService.getStatus(guid, "@friends");
    }

    private static Request getStatus(String guid, String groupId) {
        Request request = new Request(restTemplate, null, "GET");
        request.setModelClass(StatusMood.class);
        request.setGroupId(groupId);
        request.setGuid(guid);
        return request;
    }

    public static Request getStatusHistory() {
        return StatusMoodsService.getStatusHistory("@self", null);
    }

    public static Request getFriendStatusHistories() {
        return StatusMoodsService.getStatusHistory("@friends", null);
    }

    public static Request getFriendStatusHistory(String friendId) {
        return StatusMoodsService.getStatusHistory("@friends", friendId);
    }

    private static Request getStatusHistory(String groupId, String friendId) {
        Request request = new Request(restTemplate, null, "GET");
        request.setModelClass(StatusMood.class);
        request.addComponent("friendId", friendId);
        request.addComponent("history", "history");
        request.setGroupId(groupId);
        request.setGuid("@me");
        return request;
    }

    public static Request getSupportedMoods() {
        Request request = new Request(restTemplate, null, "GET");
        request.setModelClass(StatusMood.class);
        request.setGroupId("@supportedMood");
        request.setGuid("@me");
        return request;
    }

    public static Request getSupportedMood(long moodId) {
        Request request = StatusMoodsService.getSupportedMoods();
        request.addComponent("moodId", "" + moodId);
        return request;
    }

    public static Request updateStatus(StatusMood statusMood) {
        Request request = new Request(restTemplate, null, "PUT");
        request.setGroupId("@self");
        request.setGuid("@me");
        try {
            long moodId = Long.parseLong(statusMood.getMoodId());
            request.addRestPayloadParameter("moodId", moodId);
        }
        catch (NumberFormatException e) {
            request.addRestPayloadParameter("moodId", statusMood.getMoodId());
        }
        request.addRestPayloadParameter("status", statusMood.getStatus());
        return request;
    }
}

