/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import nl.surfnet.sab.Sab;
import nl.surfnet.sab.SabResponseParser;
import nl.surfnet.sab.SabRoleHolder;
import nl.surfnet.sab.SabTransport;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabClient
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private static final String REQUEST_TEMPLATE_LOCATION = "/sab-request.xml";
    protected static final DateTimeFormatter XML_DATE_TIME_FORMAT = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    @Resource
    private SabTransport transport;
    private SabResponseParser sabResponseParser = new SabResponseParser();

    @Override
    public boolean hasRoleForOrganisation(String userId, String role, String organisation) {
        try {
            SabRoleHolder sabRoleHolder = this.getRoles(userId);
            return sabRoleHolder.getOrganisation().equals(organisation) && sabRoleHolder.getRoles().contains(role);
        }
        catch (IOException e) {
            LOG.error("IOException while doing request to SAB. Will return false.", (Throwable)e);
            return false;
        }
    }

    @Override
    public SabRoleHolder getRoles(String userId) throws IOException {
        String messageId = UUID.randomUUID().toString();
        String request = this.createRequest(userId, messageId);
        return this.sabResponseParser.parse(this.transport.getResponse(request));
    }

    public String createRequest(String userId, String messageId) {
        String template;
        try {
            template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(REQUEST_TEMPLATE_LOCATION), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String issueInstant = XML_DATE_TIME_FORMAT.print(new Date().getTime());
        return MessageFormat.format(template, messageId, issueInstant, userId);
    }

    public void setTransport(SabTransport transport) {
        this.transport = transport;
    }
}

