/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.surfnet.sab.Sab;
import nl.surfnet.sab.SabRoleHolder;
import nl.surfnet.sab.SabTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabClientMock
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClientMock.class);
    private Map<String, SabRoleHolder> rolesMapping = new ConcurrentHashMap<String, SabRoleHolder>();

    public SabClientMock() {
        this.rolesMapping.put("user1", new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Bar")));
        this.rolesMapping.put("user2", new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Baz")));
    }

    @Override
    public boolean hasRoleForOrganisation(String userId, String role, String organisation) {
        return this.rolesMapping.containsKey(userId) && this.rolesMapping.get(userId).getOrganisation().equals(organisation) && this.rolesMapping.get(userId).getRoles().contains(role);
    }

    @Override
    public SabRoleHolder getRoles(String userId) throws IOException {
        SabRoleHolder sabRoleHolder = this.rolesMapping.get(userId);
        LOG.debug("Returning SAB role holder: {}", (Object)sabRoleHolder);
        return sabRoleHolder;
    }

    public void setTransport(SabTransport transport) {
    }
}

