/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import nl.surfnet.sab.SabRoleHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

@Component
public class SabResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(SabResponseParser.class);
    public static final String XPATH_ORGANISATION = "//saml:Attribute[@Name='urn:oid:1.3.6.1.4.1.1076.20.100.10.50.1']/saml:AttributeValue";
    public static final String XPATH_ROLES = "//saml:Attribute[@Name='urn:oid:1.3.6.1.4.1.5923.1.1.1.7']/saml:AttributeValue";
    public static final String XPATH_STATUSCODE = "//samlp:StatusCode/@Value";
    public static final String XPATH_STATUSMESSAGE = "//samlp:StatusMessage";
    public static final String SAMLP_SUCCESS = "urn:oasis:names:tc:SAML:2.0:status:Success";
    private static final String SAMLP_RESPONDER = "urn:oasis:names:tc:SAML:2.0:status:Responder";
    private static final String NOT_FOUND_MESSAGE_PREFIX = "Could not find any roles for given NameID";

    public SabRoleHolder parse(InputStream inputStream) throws IOException {
        String organisation = null;
        ArrayList<String> roles = new ArrayList<String>();
        XPath xpath = this.getXPath();
        try {
            Document document = this.createDocument(inputStream);
            this.validateStatus(document, xpath);
            XPathExpression organisationExpr = xpath.compile(XPATH_ORGANISATION);
            NodeList nodeList = (NodeList)organisationExpr.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node == null) continue;
                organisation = StringUtils.trimWhitespace((String)node.getTextContent());
                node.getParentNode().getTextContent();
            }
            XPathExpression rolesExpr = xpath.compile(XPATH_ROLES);
            NodeList rolesNodeList = (NodeList)rolesExpr.evaluate(document, XPathConstants.NODESET);
            for (int i = 0; rolesNodeList != null && i < rolesNodeList.getLength(); ++i) {
                Node node = rolesNodeList.item(i);
                if (node == null) continue;
                roles.add(StringUtils.trimWhitespace((String)node.getTextContent()));
            }
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return new SabRoleHolder(organisation, roles);
    }

    private void validateStatus(Document document, XPath xpath) throws XPathExpressionException, IOException {
        XPathExpression statusCodeExpression = xpath.compile(XPATH_STATUSCODE);
        String statusCode = (String)statusCodeExpression.evaluate(document, XPathConstants.STRING);
        if (SAMLP_SUCCESS.equals(statusCode)) {
            return;
        }
        XPathExpression statusMessageExpression = xpath.compile(XPATH_STATUSMESSAGE);
        String statusMessage = (String)statusMessageExpression.evaluate(document, XPathConstants.STRING);
        if (SAMLP_RESPONDER.equals(statusCode) && statusMessage.startsWith(NOT_FOUND_MESSAGE_PREFIX)) {
            LOG.debug("Given nameId not found in SAB. Is regarded by us as 'valid' response, although server response indicates a server error.");
            return;
        }
        throw new IOException("Unsuccessful status. Code: '" + statusCode + "', message: " + statusMessage);
    }

    private Document createDocument(InputStream documentStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(documentStream);
    }

    private XPath getXPath() {
        XPath xPath = XPathFactory.newInstance().newXPath();
        xPath.setNamespaceContext(new SabNgNamespaceResolver());
        return xPath;
    }

    private class SabNgNamespaceResolver
    implements NamespaceContext {
        private SabNgNamespaceResolver() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix.equals("samlp")) {
                return "urn:oasis:names:tc:SAML:2.0:protocol";
            }
            if (prefix.equals("saml")) {
                return "urn:oasis:names:tc:SAML:2.0:assertion";
            }
            return "";
        }

        @Override
        public String getPrefix(String namespaceURI) {
            return null;
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            return null;
        }
    }
}

