/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import nl.surfnet.sab.SabTransport;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class HttpClientTransport
implements SabTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private HttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
    private String username;
    private String password;
    private URI sabEndpoint;

    @Override
    public InputStream getResponse(String request) throws IOException {
        HttpPost httpPost = new HttpPost(this.sabEndpoint);
        httpPost.addHeader("Authorization", "Basic " + this.encodeUserPass(this.username, this.password));
        LOG.debug("Request to SAB at endpoint {}: {}", (Object)this.sabEndpoint, (Object)request);
        StringEntity stringEntity = new StringEntity(request);
        httpPost.setEntity((HttpEntity)stringEntity);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
        InputStream responseAsStream = response.getEntity().getContent();
        String responseAsString = IOUtils.toString((InputStream)responseAsStream);
        LOG.debug("Response from SAB: {}", (Object)responseAsString);
        return new ByteArrayInputStream(responseAsString.getBytes());
    }

    String encodeUserPass(String username, String password) {
        return new String(Base64.encodeBase64((byte[])(username + ":" + password).getBytes()));
    }

    public void setSabEndpoint(URI sabEndpoint) {
        this.sabEndpoint = sabEndpoint;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUsername(String username) {
        this.username = username;
    }
}

