/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import nl.surfnet.sab.SabTransport;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class HttpClientTransport
implements SabTransport {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientTransport.class);
    private static final Integer TIMEOUT = new Integer(10000);
    private HttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)new PoolingClientConnectionManager());
    private final UsernamePasswordCredentials samlCredentials;
    private final UsernamePasswordCredentials restCredentials;
    private final URI sabEndpoint;
    private final URI restEndPoint;

    @Autowired
    public HttpClientTransport(@Qualifier(value="samlCredentials") UsernamePasswordCredentials samlCredentials, @Qualifier(value="restCredentials") UsernamePasswordCredentials restCredentials, @Value(value="${sab.endpoint}") URI sabEndpoint, @Value(value="${sab-rest.endpoint}") URI restEndPoint) {
        this.samlCredentials = samlCredentials;
        this.restCredentials = restCredentials;
        this.sabEndpoint = sabEndpoint;
        this.restEndPoint = restEndPoint;
        this.httpClient.getParams().setParameter("http.socket.timeout", (Object)TIMEOUT);
    }

    @Override
    public InputStream getResponse(String request) throws IOException {
        HttpPost httpPost = new HttpPost(this.sabEndpoint);
        StringEntity stringEntity = new StringEntity(request);
        httpPost.setEntity((HttpEntity)stringEntity);
        return this.handleRequest((HttpRequestBase)httpPost, this.samlCredentials);
    }

    @Override
    public InputStream getRestResponse(String organisationAbbreviation, String role) {
        HttpGet httpGet = null;
        try {
            httpGet = new HttpGet(String.format("%s/profile?abbrev=%s&role=%s", this.restEndPoint, URLEncoder.encode(organisationAbbreviation, "UTF-8"), URLEncoder.encode(role, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.handleRequest((HttpRequestBase)httpGet, this.restCredentials);
    }

    private InputStream handleRequest(HttpRequestBase request, UsernamePasswordCredentials credentials) {
        try {
            request.addHeader("Authorization", "Basic " + this.encodeUserPass(credentials));
            HttpResponse httpResponse = this.httpClient.execute((HttpUriRequest)request);
            return httpResponse.getEntity().getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String encodeUserPass(UsernamePasswordCredentials credentials) {
        return new String(Base64.encodeBase64((byte[])String.format("%s:%s", credentials.getUserName(), credentials.getPassword()).getBytes()));
    }
}

