/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.surfnet.sab.Sab;
import nl.surfnet.sab.SabPerson;
import nl.surfnet.sab.SabResponseParser;
import nl.surfnet.sab.SabRole;
import nl.surfnet.sab.SabRoleHolder;
import nl.surfnet.sab.SabTransport;
import org.apache.commons.io.IOUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SabClient
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClient.class);
    private static final String REQUEST_TEMPLATE_LOCATION = "/sab-request.xml";
    protected static final DateTimeFormatter XML_DATE_TIME_FORMAT = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC);
    private final SabTransport sabTransport;
    private SabResponseParser sabResponseParser;

    @Autowired
    public SabClient(SabTransport sabTransport) {
        this.sabTransport = sabTransport;
        this.sabResponseParser = new SabResponseParser();
    }

    @Override
    public boolean hasRoleForOrganisation(String userId, String role, String organisation) {
        try {
            SabRoleHolder sabRoleHolder = this.getRoles(userId);
            return sabRoleHolder.getOrganisation().equals(organisation) && sabRoleHolder.getRoles().contains(role);
        }
        catch (IOException e) {
            LOG.error("IOException while doing request to SAB. Will return false.", (Throwable)e);
            return false;
        }
    }

    @Override
    public SabRoleHolder getRoles(String userId) throws IOException {
        String messageId = UUID.randomUUID().toString();
        String request = this.createRequest(userId, messageId);
        return this.sabResponseParser.parse(this.sabTransport.getResponse(request));
    }

    @Override
    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, final String role) {
        try {
            InputStream responseAsStream = this.sabTransport.getRestResponse(organisationAbbreviation, role);
            HashMap result = (HashMap)new ObjectMapper().readValue(responseAsStream, HashMap.class);
            List allSabPersons = Lists.transform((List)((List)result.get("profiles")), (Function)new Function<Map, SabPerson>(){

                public SabPerson apply(Map person) {
                    List sabRoles = Lists.transform((List)((List)person.get("authorisations")), (Function)new Function<Map, SabRole>(){

                        public SabRole apply(Map role) {
                            return new SabRole((String)role.get("short"), (String)role.get("role"));
                        }
                    });
                    return new SabPerson((String)person.get("firstname"), (String)person.get("surname"), (String)person.get("uid"), sabRoles);
                }
            });
            Collection sabPersons = Collections2.filter((Collection)allSabPersons, (Predicate)new Predicate<SabPerson>(){

                public boolean apply(SabPerson person) {
                    return person.hasRole(role);
                }
            });
            return sabPersons;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String createRequest(String userId, String messageId) {
        String template;
        try {
            template = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(REQUEST_TEMPLATE_LOCATION), (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String issueInstant = XML_DATE_TIME_FORMAT.print(new Date().getTime());
        return MessageFormat.format(template, messageId, issueInstant, userId);
    }
}

