/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import nl.surfnet.sab.Sab;
import nl.surfnet.sab.SabPerson;
import nl.surfnet.sab.SabRole;
import nl.surfnet.sab.SabRoleHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SabClientMock
implements Sab {
    private static final Logger LOG = LoggerFactory.getLogger(SabClientMock.class);
    private static final SabRole ROLE_BEHEERDER = new SabRole("CONBEH", "SURFconextbeheerder");
    private static final SabRole ROLE_VERANTWOORDELIJKE = new SabRole("CONVER", "SURFconextverantwoordelijke");
    private final List<SabPerson> sabPersons = Arrays.asList(new SabPerson("Hans", "Janssen", "hjanssen", Arrays.asList(ROLE_BEHEERDER)), new SabPerson("Frans", "Franssen", "ffransen", Arrays.asList(ROLE_BEHEERDER, ROLE_VERANTWOORDELIJKE)));
    private Map<String, SabRoleHolder> rolesMapping = new ConcurrentHashMap<String, SabRoleHolder>();

    public SabClientMock() {
        this.rolesMapping.put("user1", new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Bar")));
        this.rolesMapping.put("user2", new SabRoleHolder("SURFNET", Arrays.asList("Foo", "Baz")));
    }

    @Override
    public boolean hasRoleForOrganisation(String userId, String role, String organisation) {
        return this.rolesMapping.containsKey(userId) && this.rolesMapping.get(userId).getOrganisation().equals(organisation) && this.rolesMapping.get(userId).getRoles().contains(role);
    }

    @Override
    public SabRoleHolder getRoles(String userId) throws IOException {
        SabRoleHolder sabRoleHolder = this.rolesMapping.get(userId);
        LOG.debug("Returning SAB role holder: {}", (Object)sabRoleHolder);
        return sabRoleHolder;
    }

    @Override
    public Collection<SabPerson> getPersonsInRoleForOrganization(String organisationAbbreviation, String role) {
        ArrayList<SabPerson> result = new ArrayList<SabPerson>();
        for (SabPerson sabPerson : this.sabPersons) {
            Collection roleNames = Collections2.transform(sabPerson.getRoles(), (Function)new Function<SabRole, String>(){

                public String apply(SabRole input) {
                    return input.roleName;
                }
            });
            if (!roleNames.contains(role)) continue;
            result.add(sabPerson);
        }
        return result;
    }
}

