/*
 * Decompiled with CFR 0.152.
 */
package nl.surfnet.sab;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import nl.surfnet.sab.SabRole;

public class SabPerson {
    private final String firstName;
    private final String surname;
    private final String uid;
    private final List<SabRole> roles;

    public SabPerson(String firstName, String surname, String uid, List<SabRole> roles) {
        this.firstName = firstName;
        this.surname = surname;
        this.uid = uid;
        this.roles = roles;
    }

    public String fullname() {
        return String.format("%s %s", this.firstName, this.surname);
    }

    public boolean hasRole(final String role) {
        return Iterables.any(this.roles, (Predicate)new Predicate<SabRole>(){

            public boolean apply(SabRole sabRole) {
                return sabRole.roleName.equals(role);
            }
        });
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getSurname() {
        return this.surname;
    }

    public String getUid() {
        return this.uid;
    }

    public List<SabRole> getRoles() {
        return this.roles;
    }
}

