/*
 * Copyright 2012 SURFnet bv, The Netherlands
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package selfservice.domain;

import java.io.Serializable;
import java.util.Map;

import com.google.common.base.MoreObjects;
import com.google.common.base.MoreObjects.ToStringHelper;

import org.springframework.util.CollectionUtils;

@SuppressWarnings("serial")
public class ServiceProvider extends Provider implements Serializable {

  private String id;
  private String gadgetBaseUrl;
  private String applicationUrl;
  private String institutionId;
  private String eulaURL;

  private boolean display;
  private boolean publishedInEdugain;
  private boolean exampleSingleTenant;

  private ARP arp;

  private Map<String, String> urls;

  public ServiceProvider(String id) {
    this.id = id;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public boolean isIdpVisibleOnly() {
    return !display;
  }

  public void setIdpVisibleOnly(boolean idpVisibleOnly) {
    this.display = !idpVisibleOnly;
  }

  public String getEulaURL() {
    return eulaURL;
  }

  public void setEulaURL(String eulaURL) {
    this.eulaURL = eulaURL;
  }

  public Map<String, String> getUrls() {
    return urls;
  }

  public String getUrl() {
    return CollectionUtils.isEmpty(this.urls) ? null : urls.values().iterator().next();
  }

  public void setUrls(Map<String, String> urls) {
    this.urls = urls;
  }

  public String getGadgetBaseUrl() {
    return gadgetBaseUrl;
  }

  public void setGadgetBaseUrl(String gadgetBaseUrl) {
    this.gadgetBaseUrl = gadgetBaseUrl;
  }

  public ARP getArp() {
    return arp;
  }

  public void setArp(ARP arp) {
    this.arp = arp;
  }

  public boolean isPublishedInEdugain() {
    return publishedInEdugain;
  }

  public void setPublishedInEdugain(boolean publishedInEdugain) {
    this.publishedInEdugain = publishedInEdugain;
  }

  public boolean isExampleSingleTenant() {
    return exampleSingleTenant;
  }

  public void setExampleSingleTenant(boolean exampleSingleTenant) {
    this.exampleSingleTenant = exampleSingleTenant;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ServiceProvider that = (ServiceProvider) o;

    if (id != null ? !id.equals(that.id) : that.id != null) {
      return false;
    }

    return true;
  }

  @Override
  public int hashCode() {
    return (id == null) ? 0 : id.hashCode();
  }

  public String getApplicationUrl() {
    return applicationUrl;
  }

  public void setApplicationUrl(String applicationUrl) {
    this.applicationUrl = applicationUrl;
  }

  public String getInstitutionId() {
    return institutionId;
  }

  public void setInstitutionId(String institutionId) {
    this.institutionId = institutionId;
  }

  @Override
  public String toString() {
    ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("id", id);

    if (arp != null) {
      toStringHelper.add("arp", arp);
    }

    return toStringHelper
        .add("eulaUrl", eulaURL)
        .add("gadgetBaseUrl", gadgetBaseUrl)
        .add("idpVisibleOnly", isIdpVisibleOnly()).toString();
  }

}
