/*
 * Decompiled with CFR 0.152.
 */
package selfservice;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import selfservice.api.dashboard.GsonHttpMessageConverter;
import selfservice.interceptor.MenuInterceptor;

@Configuration
public class WebConfig
extends WebMvcConfigurerAdapter {
    @Value(value="${statsBaseUrl}")
    private String statsBaseUrl;
    @Value(value="${statsAuthorizePath}")
    private String statsAuthorizePath;
    @Value(value="${statsClientId}")
    private String statsClientId;
    @Value(value="${statsScope}")
    private String statsScope;
    @Value(value="${statsRedirectUri}")
    private String statsRedirectUri;
    @Autowired
    private Environment environment;

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.mediaType("csv", new MediaType("text", "csv"));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        LocaleChangeInterceptor localeChangeInterceptor = new LocaleChangeInterceptor();
        localeChangeInterceptor.setParamName("lang");
        registry.addInterceptor((HandlerInterceptor)localeChangeInterceptor);
        registry.addInterceptor((HandlerInterceptor)new MenuInterceptor());
        registry.addInterceptor((HandlerInterceptor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)new GsonHttpMessageConverter(this.environment, this.statsBaseUrl, this.statsAuthorizePath, this.statsClientId, this.statsScope, this.statsRedirectUri));
    }
}

