/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.dashboard;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;
import selfservice.api.dashboard.EnrichJson;
import selfservice.api.dashboard.GsonHttpMessageConverter;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.Service;
import selfservice.util.AttributeMapFilter;

public class EnrichJson {
    public static final String FILTERED_USER_ATTRIBUTES = "filteredUserAttributes";
    public static final String SUPER_USER = "superUser";
    public static final String DASHBOARD_ADMIN = "dashboardAdmin";
    public static final String STATS_URL = "statsUrl";
    private static final Logger logger = LoggerFactory.getLogger(EnrichJson.class);
    private Map<Class<?>, JsonApplier> mapping = new HashMap();
    private CoinUser currentUser;
    private boolean localProfile;
    private JsonElement json;

    private EnrichJson(Environment environment, CoinUser coinUser, String statsUrl) {
        logger.debug("Using {} for user {}", (Object)statsUrl, (Object)coinUser.getDisplayName());
        this.currentUser = coinUser;
        this.localProfile = environment.acceptsProfiles(new String[]{"local"});
        Gson gson = GsonHttpMessageConverter.GSON_BUILDER.create();
        this.mapping.put(CoinUser.class, (coinUserJsonElement, payload) -> {
            JsonObject user = coinUserJsonElement.getAsJsonObject();
            this.filterDashboardAuthorities(user);
            user.addProperty(SUPER_USER, Boolean.valueOf(((CoinUser)payload).isSuperUser()));
            user.addProperty(DASHBOARD_ADMIN, Boolean.valueOf(((CoinUser)payload).isDashboardAdmin()));
            user.addProperty(STATS_URL, statsUrl);
            user.addProperty("localProfile", Boolean.valueOf(this.localProfile));
        });
        this.mapping.put(Service.class, (serviceJsonElement, payload) -> {
            Service service = (Service)payload;
            JsonArray filteredUserAttributes = new JsonArray();
            if (service.getArp() != null && !service.getArp().isNoArp() && !service.getArp().isNoAttrArp()) {
                AttributeMapFilter.filterAttributes((Map)service.getArp().getAttributes(), (Map)this.currentUser.getAttributeMap()).stream().map(arg_0 -> ((Gson)gson).toJsonTree(arg_0)).forEach(arg_0 -> ((JsonArray)filteredUserAttributes).add(arg_0));
            }
            serviceJsonElement.getAsJsonObject().add(FILTERED_USER_ATTRIBUTES, (JsonElement)filteredUserAttributes);
        });
    }

    public static EnrichJson forUser(Environment environment, CoinUser currentUser, String statsUrl) {
        return new EnrichJson(environment, currentUser, statsUrl);
    }

    private void filterDashboardAuthorities(JsonObject user) {
        Iterator authorities = user.getAsJsonArray("grantedAuthorities").iterator();
        while (authorities.hasNext()) {
            JsonElement authority = (JsonElement)authorities.next();
            if (!authority.isJsonObject() || CoinAuthority.Authority.valueOf((String)authority.getAsJsonObject().get("authority").getAsString()).isDashboardAuthority()) continue;
            authorities.remove();
        }
    }

    public EnrichJson json(JsonElement json) {
        this.json = json;
        return this;
    }

    public void forPayload(Object payload) {
        Preconditions.checkNotNull((Object)this.json);
        Preconditions.checkNotNull((Object)payload);
        JsonElement payloadAsJsonElement = this.json.getAsJsonObject().get("payload");
        if (payloadAsJsonElement.isJsonObject()) {
            if (this.mapping.containsKey(payload.getClass())) {
                ((JsonApplier)this.mapping.get(payload.getClass())).apply(payloadAsJsonElement, payload);
            }
        } else if (payloadAsJsonElement.isJsonArray()) {
            JsonArray jsonArray = payloadAsJsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Class<?> classOfPayloadElement = ((List)payload).get(i).getClass();
                if (!this.mapping.containsKey(classOfPayloadElement)) continue;
                ((JsonApplier)this.mapping.get(classOfPayloadElement)).apply(jsonArray.get(i), ((List)payload).get(i));
            }
        }
    }
}

