/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.dashboard;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import selfservice.api.dashboard.BaseController;
import selfservice.api.dashboard.RestResponse;
import selfservice.domain.Action;
import selfservice.domain.Change;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.IdentityProvider;
import selfservice.domain.Provider;
import selfservice.domain.Service;
import selfservice.domain.Settings;
import selfservice.domain.csa.ContactPerson;
import selfservice.manage.Manage;
import selfservice.service.ActionsService;
import selfservice.service.Services;
import selfservice.util.SpringSecurity;

@RestController
@RequestMapping(value={"/dashboard/api/users"}, produces={"application/json"})
public class UsersController
extends BaseController {
    @Autowired
    private Manage manage;
    @Autowired
    private Services services;
    @Autowired
    private ActionsService actionsService;

    @RequestMapping(value={"/me"})
    public RestResponse<CoinUser> me() {
        return this.createRestResponse((Object)SpringSecurity.getCurrentUser());
    }

    @RequestMapping(value={"/super/idps"})
    public ResponseEntity<RestResponse<Map<String, List<?>>>> idps() {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (!currentUser.isSuperUser()) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        List idps = this.manage.getAllIdentityProviders().stream().sorted(Comparator.comparing(Provider::getName)).collect(Collectors.toList());
        List<String> roles = Arrays.asList(CoinAuthority.Authority.ROLE_DASHBOARD_VIEWER.name(), CoinAuthority.Authority.ROLE_DASHBOARD_ADMIN.name());
        HashMap<String, List<Object>> payload = new HashMap<String, List<Object>>();
        payload.put("idps", idps);
        payload.put("roles", roles);
        return new ResponseEntity((Object)this.createRestResponse(payload), HttpStatus.OK);
    }

    @RequestMapping(value={"/me/serviceproviders"}, method={RequestMethod.GET})
    public RestResponse<List<Service>> serviceProviders(Locale locale) throws IOException {
        List usersServices = this.getServiceProvidersForCurrentUser(locale);
        return this.createRestResponse((Object)usersServices);
    }

    private List<Service> getServiceProvidersForCurrentUser(Locale locale) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        Optional switchedToIdp = currentUser.getSwitchedToIdp();
        String usersInstitutionId = switchedToIdp.isPresent() ? ((IdentityProvider)switchedToIdp.get()).getInstitutionId() : currentUser.getInstitutionId();
        return Strings.isNullOrEmpty((String)usersInstitutionId) ? Collections.emptyList() : this.services.getInstitutionalServicesForIdp(usersInstitutionId, locale);
    }

    @RequestMapping(value={"/me/switch-to-idp"})
    public ResponseEntity<Void> currentIdp(@RequestParam(value="idpId", required=false) String switchToIdp, @RequestParam(value="role", required=false) String role, HttpServletResponse response) {
        if (Strings.isNullOrEmpty((String)switchToIdp)) {
            SpringSecurity.clearSwitchedIdp();
        } else {
            IdentityProvider identityProvider = (IdentityProvider)this.manage.getIdentityProvider(switchToIdp).orElseThrow(() -> new SecurityException(switchToIdp + " does not exist"));
            SpringSecurity.setSwitchedToIdp((IdentityProvider)identityProvider, (String)role);
        }
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/me/settings"}, method={RequestMethod.POST})
    public ResponseEntity<RestResponse<Object>> updateSettings(@RequestHeader(value="X-IDP-ENTITY-ID") String idpEntityId, Locale locale, @RequestBody Settings settings) throws IOException {
        CoinUser currentUser = SpringSecurity.getCurrentUser();
        if (currentUser.isSuperUser() || !currentUser.isDashboardAdmin() && currentUser.isDashboardViewer()) {
            return new ResponseEntity(HttpStatus.FORBIDDEN);
        }
        IdentityProvider idp = currentUser.getIdp();
        ArrayList<Change> changes = new ArrayList<Change>();
        if (this.changed(settings.getKeywordsEn(), (String)idp.getKeywords().get("en"))) {
            changes.add(new Change(idp.getId(), "keywords:en", (String)idp.getKeywords().get("en"), settings.getKeywordsEn()));
        }
        if (this.changed(settings.getKeywordsNl(), (String)idp.getKeywords().get("nl"))) {
            changes.add(new Change(idp.getId(), "keywords:nl", (String)idp.getKeywords().get("nl"), settings.getKeywordsNl()));
        }
        if (settings.isPublishedInEdugain() != idp.isPublishedInEdugain()) {
            changes.add(new Change(idp.getId(), "coin:publish_in_edugain", Boolean.toString(idp.isPublishedInEdugain()), Boolean.toString(settings.isPublishedInEdugain())));
        }
        List contactPersons = idp.getContactPersons();
        List newContactPersons = settings.getContactPersons();
        for (int i = 0; i < contactPersons.size(); ++i) {
            ContactPerson contactPerson = (ContactPerson)contactPersons.get(i);
            if (newContactPersons == null || newContactPersons.size() < i + 1) continue;
            ContactPerson newContactPerson = (ContactPerson)newContactPersons.get(i);
            if (this.changed(contactPerson.getName(), newContactPerson.getName())) {
                changes.add(new Change(idp.getId(), "contacts:" + i + ":name", contactPerson.getName(), newContactPerson.getName()));
            }
            if (this.changed(contactPerson.getEmailAddress(), newContactPerson.getEmailAddress())) {
                changes.add(new Change(idp.getId(), "contacts:" + i + ":emailAddress", contactPerson.getEmailAddress(), newContactPerson.getEmailAddress()));
            }
            if (this.changed(contactPerson.getTelephoneNumber(), newContactPerson.getTelephoneNumber())) {
                changes.add(new Change(idp.getId(), "contacts:" + i + ":telephoneNumber", contactPerson.getTelephoneNumber(), newContactPerson.getTelephoneNumber()));
            }
            if (contactPerson.getContactPersonType() == newContactPerson.getContactPersonType()) continue;
            changes.add(new Change(idp.getId(), "contacts:" + i + ":contactType", contactPerson.getContactPersonType().toString(), newContactPerson.getContactPersonType().toString()));
        }
        List serviceProviders = this.getServiceProvidersForCurrentUser(locale);
        settings.getServiceProviderSettings().forEach(sp -> {
            Optional<Service> first = serviceProviders.stream().filter(service -> service.getSpEntityId().equals(sp.getSpEntityId())).findFirst();
            first.ifPresent(service -> {
                if (sp.isHasGuestEnabled() != service.isGuestEnabled()) {
                    changes.add(new Change(sp.getSpEntityId(), "Guest Login Enabled", Boolean.toString(service.isGuestEnabled()), Boolean.toString(sp.isHasGuestEnabled())));
                }
                if (sp.isNoConsentRequired() != service.isNoConsentRequired()) {
                    changes.add(new Change(sp.getSpEntityId(), "coin:no_consent_required", Boolean.toString(service.isNoConsentRequired()), Boolean.toString(sp.isNoConsentRequired())));
                }
                if (sp.isPublishedInEdugain() != service.isPublishedInEdugain()) {
                    changes.add(new Change(sp.getSpEntityId(), "coin:publish_in_edugain", Boolean.toString(service.isPublishedInEdugain()), Boolean.toString(sp.isPublishedInEdugain())));
                }
                if (this.changed(sp.getDescriptionEn(), (String)service.getDescriptions().get("en"))) {
                    changes.add(new Change(sp.getSpEntityId(), "description:en", (String)service.getDescriptions().get("en"), sp.getDescriptionEn()));
                }
                if (this.changed(sp.getDescriptionNl(), (String)service.getDescriptions().get("nl"))) {
                    changes.add(new Change(sp.getSpEntityId(), "description:nl", (String)service.getDescriptions().get("nl"), sp.getDescriptionNl()));
                }
            });
        });
        if (changes.isEmpty()) {
            return ResponseEntity.ok((Object)this.createRestResponse(Collections.singletonMap("no-changes", true)));
        }
        Action action = Action.builder().userEmail(currentUser.getEmail()).userName(currentUser.getUsername()).idpId(idpEntityId).settings(settings).type(Action.Type.CHANGE).build();
        this.actionsService.create(action, changes);
        return ResponseEntity.ok((Object)this.createRestResponse((Object)action));
    }

    private boolean changed(String oldValue, String newValue) {
        boolean oldValueHasText = StringUtils.hasText((String)oldValue);
        boolean newValueHasText = StringUtils.hasText((String)newValue);
        if (!oldValueHasText && !newValueHasText) {
            return false;
        }
        if (oldValueHasText && !newValueHasText) {
            return true;
        }
        if (!oldValueHasText && newValueHasText) {
            return true;
        }
        return !oldValue.equals(newValue);
    }
}

