/*
 * Decompiled with CFR 0.152.
 */
package selfservice.api.dashboard;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import selfservice.api.dashboard.EnrichJson;
import selfservice.api.dashboard.ExcludeJsonIgnore;
import selfservice.api.dashboard.GsonHttpMessageConverter;
import selfservice.api.dashboard.RestResponse;
import selfservice.domain.CoinUser;
import selfservice.shibboleth.ShibbolethHeader;
import selfservice.util.SpringSecurity;

public class GsonHttpMessageConverter
extends AbstractHttpMessageConverter<RestResponse<?>> {
    public static final GsonBuilder GSON_BUILDER = new GsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{new ExcludeJsonIgnore()}).enableComplexMapKeySerialization().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeTypeAdapter(null).nullSafe()).registerTypeAdapter(ShibbolethHeader.class, (Object)new ShibbolethHeaderTypeAdapter(null).nullSafe());
    private Environment environment;
    private Gson gson;
    private String statsBaseUrl;
    private String statsAuthorizePath;
    private String statsClientId;
    private String statsScope;
    private String statsRedirectUri;

    public GsonHttpMessageConverter(Environment environment, String statsBaseUr, String statsAuthorizePath, String statsClientId, String statsScope, String statsRedirectUri) {
        this.environment = environment;
        this.gson = GSON_BUILDER.create();
        this.statsBaseUrl = statsBaseUr;
        this.statsAuthorizePath = statsAuthorizePath;
        this.statsClientId = statsClientId;
        this.statsScope = statsScope;
        this.statsRedirectUri = statsRedirectUri;
    }

    public boolean canRead(Class<?> clazz, MediaType mediaType) {
        return false;
    }

    public boolean canWrite(Class<?> clazz, MediaType mediaType) {
        return clazz.isAssignableFrom(RestResponse.class) && mediaType != null && mediaType.equals((Object)MediaType.APPLICATION_JSON);
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Arrays.asList(MediaType.APPLICATION_JSON);
    }

    protected boolean supports(Class<?> clazz) {
        return false;
    }

    protected RestResponse<?> readInternal(Class<? extends RestResponse<?>> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        throw new UnsupportedOperationException("nyi");
    }

    protected void writeInternal(RestResponse<?> objectRestResponse, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        JsonElement json = this.gson.toJsonTree(objectRestResponse);
        EnrichJson.forUser((Environment)this.environment, (CoinUser)SpringSecurity.getCurrentUser(), (String)String.format("%s/%s?response_type=token&client_id=%s&scope=%s&redirect_uri=%s", this.statsBaseUrl, this.statsAuthorizePath, this.statsClientId, this.statsScope, this.statsRedirectUri)).json(json).forPayload(objectRestResponse.getPayload());
        Charset charset = this.getCharset(outputMessage.getHeaders());
        try (OutputStreamWriter jsonWriter = new OutputStreamWriter(outputMessage.getBody(), charset);){
            this.gson.toJson(json, (Appendable)jsonWriter);
        }
        catch (JsonIOException e) {
            throw new HttpMessageNotWritableException("Could not write JSON: " + e.getMessage(), (Throwable)e);
        }
    }

    private Charset getCharset(HttpHeaders headers) {
        if (headers == null || headers.getContentType() == null || headers.getContentType().getCharset() == null) {
            return StandardCharsets.UTF_8;
        }
        return headers.getContentType().getCharset();
    }

    public void setStatsBaseUrl(String statsBaseUrl) {
        this.statsBaseUrl = statsBaseUrl;
    }

    public void setStatsClientId(String statsClientId) {
        this.statsClientId = statsClientId;
    }

    public void setStatsScope(String statsScope) {
        this.statsScope = statsScope;
    }

    public void setStatsRedirectUri(String statsRedirectUri) {
        this.statsRedirectUri = statsRedirectUri;
    }
}

