/*
 * Decompiled with CFR 0.152.
 */
package selfservice.interceptor;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import selfservice.domain.CoinAuthority;
import selfservice.domain.CoinUser;
import selfservice.domain.csa.Menu;
import selfservice.domain.csa.MenuItem;
import selfservice.interceptor.MenuInterceptor;

public class MenuInterceptor
extends HandlerInterceptorAdapter {
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null) {
            return;
        }
        Optional.ofNullable(SecurityContextHolder.getContext().getAuthentication()).ifPresent(auth -> {
            ModelMap map = modelAndView.getModelMap();
            Menu menu = this.createMenu((CoinUser)auth.getPrincipal());
            this.setSelected(request, menu);
            map.addAttribute("menu", (Object)menu);
        });
    }

    private void setSelected(HttpServletRequest request, Menu menu) {
        String requestURI = request.getRequestURI();
        menu.getMenuItems().stream().filter(mi -> requestURI.endsWith(mi.getUrl())).findFirst().ifPresent(mi -> mi.setSelected(true));
    }

    private Menu createMenu(CoinUser coinUser) {
        Menu menu = new Menu();
        for (CoinAuthority.Authority authority : coinUser.getAuthorityEnums()) {
            switch (1.$SwitchMap$selfservice$domain$CoinAuthority$Authority[authority.ordinal()]) {
                case 1: {
                    menu.addMenuItem(new MenuItem("jsp.allsplmng.title", "/shopadmin/all-spslmng.shtml"));
                    menu.addMenuItem(new MenuItem("jsp.taxonomy.title", "/shopadmin/taxonomy-overview.shtml"));
                    menu.addMenuItem(new MenuItem("jsp.cspstatus.title", "/shopadmin/csp-status-overview.shtml"));
                    menu.addMenuItem(new MenuItem("jsp.license_contact_persons.title", "/shopadmin/license-contact-persons.shtml"));
                    break;
                }
            }
        }
        return menu;
    }
}

