/*
 * Decompiled with CFR 0.152.
 */
package selfservice.sab;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import selfservice.sab.SabResponseParser;
import selfservice.sab.SabRoleHolder;

@Component
public class SabResponseParser {
    private static final Logger LOG = LoggerFactory.getLogger(SabResponseParser.class);
    public static final String XPATH_ORGANISATION = "//saml:Attribute[@Name='urn:oid:1.3.6.1.4.1.1076.20.100.10.50.1']/saml:AttributeValue";
    public static final String XPATH_ROLES = "//saml:Attribute[@Name='urn:oid:1.3.6.1.4.1.5923.1.1.1.7']/saml:AttributeValue";
    public static final String XPATH_STATUSCODE = "//samlp:StatusCode/@Value";
    public static final String XPATH_STATUSMESSAGE = "//samlp:StatusMessage";
    public static final String SAMLP_SUCCESS = "urn:oasis:names:tc:SAML:2.0:status:Success";
    private static final String SAMLP_RESPONDER = "urn:oasis:names:tc:SAML:2.0:status:Responder";
    private static final String NOT_FOUND_MESSAGE_PREFIX = "Could not find any roles for given NameID";
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private final XPathFactory xPathFactory;

    public SabResponseParser() {
        this.documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        this.documentBuilderFactory.setValidating(false);
        this.xPathFactory = XPathFactory.newInstance();
    }

    public SabRoleHolder parse(InputStream inputStream) throws IOException {
        String organisation = null;
        List roles = new ArrayList();
        XPath xpath = this.getXPath();
        try {
            Document document = this.createDocument(inputStream);
            this.validateStatus(document, xpath);
            organisation = this.extractOrganisation(xpath, document);
            roles = this.extractRoles(xpath, document);
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        return new SabRoleHolder(organisation, roles);
    }

    private List<String> extractRoles(XPath xpath, Document document) throws XPathExpressionException {
        ArrayList<String> roles = new ArrayList<String>();
        XPathExpression rolesExpr = xpath.compile(XPATH_ROLES);
        NodeList rolesNodeList = (NodeList)rolesExpr.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; rolesNodeList != null && i < rolesNodeList.getLength(); ++i) {
            Node node = rolesNodeList.item(i);
            if (node == null) continue;
            roles.add(StringUtils.trimWhitespace((String)node.getTextContent()));
        }
        return roles;
    }

    private String extractOrganisation(XPath xpath, Document document) throws XPathExpressionException {
        XPathExpression organisationExpr = xpath.compile(XPATH_ORGANISATION);
        NodeList nodeList = (NodeList)organisationExpr.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; nodeList != null && i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node == null) continue;
            return StringUtils.trimWhitespace((String)node.getTextContent());
        }
        return null;
    }

    private void validateStatus(Document document, XPath xpath) throws XPathExpressionException, IOException {
        XPathExpression statusCodeExpression = xpath.compile(XPATH_STATUSCODE);
        String statusCode = (String)statusCodeExpression.evaluate(document, XPathConstants.STRING);
        if (!SAMLP_SUCCESS.equals(statusCode)) {
            XPathExpression statusMessageExpression = xpath.compile(XPATH_STATUSMESSAGE);
            String statusMessage = (String)statusMessageExpression.evaluate(document, XPathConstants.STRING);
            if (SAMLP_RESPONDER.equals(statusCode) && statusMessage.startsWith(NOT_FOUND_MESSAGE_PREFIX)) {
                LOG.debug("Given nameId not found in SAB. Is regarded by us as 'valid' response, although server response indicates a server error.");
            } else {
                throw new IOException(String.format("Unsuccessful status. Code: '%s', message: %s, document:\n %s", statusCode, statusMessage, this.prettyPrintDocument(document)));
            }
        }
    }

    private String prettyPrintDocument(Document document) {
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "no");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StringWriter stringWriter = new StringWriter();
            transformer.transform(new DOMSource(document), new StreamResult(stringWriter));
            return stringWriter.getBuffer().toString();
        }
        catch (TransformerException | TransformerFactoryConfigurationError e) {
            LOG.error("Failed to pretty print a document", e);
            return "";
        }
    }

    private Document createDocument(InputStream documentStream) throws ParserConfigurationException, IOException, SAXException {
        return this.documentBuilderFactory.newDocumentBuilder().parse(documentStream);
    }

    private XPath getXPath() {
        XPath xPath = this.xPathFactory.newXPath();
        xPath.setNamespaceContext((NamespaceContext)new SabNgNamespaceResolver(null));
        return xPath;
    }
}

