/*
 * Decompiled with CFR 0.152.
 */
package selfservice.shibboleth.mock;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.filter.GenericFilterBean;
import selfservice.shibboleth.ShibbolethHeader;
import selfservice.shibboleth.ShibbolethPreAuthenticatedProcessingFilter;
import selfservice.shibboleth.mock.MockShibbolethFilter;

public class MockShibbolethFilter
extends GenericFilterBean {
    public static final String idp = "http://mock-idp";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        String userId = Optional.ofNullable(request.getParameter("mockUser")).orElse((String)req.getSession().getAttribute("mockShibbolethUser"));
        if (userId == null) {
            String login = IOUtils.toString((InputStream)new ClassPathResource("mockLogin.html").getInputStream());
            response.getWriter().write(login);
        } else {
            req.getSession(true).setAttribute("mockShibbolethUser", (Object)userId);
            SetHeader wrapper = new SetHeader(req);
            wrapper.setHeader(ShibbolethHeader.Name_Id.getValue(), userId);
            wrapper.setHeader(ShibbolethHeader.Shib_Uid.getValue(), userId);
            wrapper.setHeader(ShibbolethHeader.Shib_Authenticating_Authority.getValue(), idp);
            wrapper.setHeader(ShibbolethHeader.Shib_DisplayName.getValue(), "Jane Roe");
            wrapper.setHeader(ShibbolethHeader.Shib_SchacPersonalUniqueCode.getValue(), "schac_personal_unique_code");
            wrapper.setHeader("X-IDP-ENTITY-ID", idp);
            wrapper.setHeader(((ShibbolethHeader)ShibbolethPreAuthenticatedProcessingFilter.shibHeaders.get("urn:mace:dir:attribute-def:eduPersonEntitlement")).getValue(), "urn:mace:terena.org:tcs:personal-user;some-filtered-value");
            chain.doFilter((ServletRequest)wrapper, response);
        }
    }
}

