/*
 * Decompiled with CFR 0.152.
 */
package selfservice;

import java.util.Locale;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.actuate.autoconfigure.MetricFilterAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceRepositoryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.TraceWebFilterAutoConfiguration;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.freemarker.FreeMarkerAutoConfiguration;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.LocaleResolver;
import selfservice.manage.ClassPathResourceManage;
import selfservice.manage.Manage;
import selfservice.manage.UrlResourceManage;
import selfservice.pdp.PdpService;
import selfservice.pdp.PdpServiceImpl;
import selfservice.pdp.PdpServiceMock;
import selfservice.sab.HttpClientTransport;
import selfservice.sab.Sab;
import selfservice.sab.SabClient;
import selfservice.sab.SabClientMock;
import selfservice.sab.SabTransport;
import selfservice.service.Services;
import selfservice.service.VootClient;
import selfservice.service.impl.JiraClient;
import selfservice.service.impl.JiraClientImpl;
import selfservice.service.impl.JiraClientMock;
import selfservice.service.impl.ServicesImpl;
import selfservice.service.impl.VootClientImpl;
import selfservice.service.impl.VootClientMock;
import selfservice.util.CookieThenAcceptHeaderLocaleResolver;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class, FreeMarkerAutoConfiguration.class, TraceWebFilterAutoConfiguration.class, TraceRepositoryAutoConfiguration.class, MetricFilterAutoConfiguration.class})
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, (String[])args);
    }

    @Bean
    public Services services() {
        return new ServicesImpl();
    }

    @Bean
    public Sab sab(HttpClientTransport httpClientTransport, @Value(value="${dashboard.feature.sab}") boolean sabEnabled) {
        return sabEnabled ? new SabClient((SabTransport)httpClientTransport) : new SabClientMock();
    }

    @Bean
    public VootClient vootClient(@Value(value="${dashboard.feature.voot}") boolean vootEnabled, @Value(value="${voot.accessTokenUri}") String accessTokenUri, @Value(value="${voot.clientId}") String clientId, @Value(value="${voot.clientSecret}") String clientSecret, @Value(value="${voot.scopes}") String spaceDelimitedScopes, @Value(value="${voot.serviceUrl}") String serviceUrl) {
        return vootEnabled ? new VootClientImpl(accessTokenUri, clientId, clientSecret, spaceDelimitedScopes, serviceUrl) : new VootClientMock();
    }

    @Bean
    public Manage urlResourceServiceRegistry(@Value(value="${dashboard.feature.manage}") boolean manageEnabled, @Value(value="${manage.username}") String username, @Value(value="${manage.password}") String password, @Value(value="${manage.manageBaseUrl}") String manageBaseUrl) {
        return manageEnabled ? new UrlResourceManage(username, password, manageBaseUrl) : new ClassPathResourceManage();
    }

    @Bean
    public JiraClient jiraClient(@Value(value="${dashboard.feature.jira}") boolean jiraEnabled, @Value(value="${jiraBaseUrl}") String baseUrl, @Value(value="${jiraUsername}") String username, @Value(value="${jiraPassword}") String password, @Value(value="${jiraProjectKey}") String projectKey) {
        return jiraEnabled ? new JiraClientImpl(baseUrl, username, password, projectKey) : new JiraClientMock();
    }

    @Bean
    public PdpService pdpService(@Value(value="${dashboard.feature.manage}") boolean pdpEnabled, @Value(value="${pdp.server}") String server, @Value(value="${pdp.username}") String username, @Value(value="${pdp.password}") String password) {
        return pdpEnabled ? new PdpServiceImpl(server, username, password) : new PdpServiceMock();
    }

    @Bean
    public LocaleResolver localeResolver() {
        CookieThenAcceptHeaderLocaleResolver localeResolver = new CookieThenAcceptHeaderLocaleResolver();
        localeResolver.setCookieName("dashboardLang");
        localeResolver.setDefaultLocale(new Locale("nl"));
        localeResolver.setCookieMaxAge(Integer.valueOf(315360000));
        return localeResolver;
    }
}

